% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chest_plot.R
\name{chest_plot}
\alias{chest_plot}
\title{Plot effect estimate and change-in-estimate values (ggplot type)}
\usage{
chest_plot(
  data,
  no_values = FALSE,
  ylab = NULL,
  xlab = NULL,
  change_lab = "Change, \%",
  digits = "\%.2f",
  digits_change = "\%.1f",
  plus = "  + ",
  nudge_y = 0.4,
  nudge_x = NULL,
  hjust = 0.5,
  height = 0.06,
  point_size = 3,
  point_shape = 15,
  vline_type = "dashed",
  vline_color = "grey50",
  ebar_color = "grey50",
  zero = 1,
  value_position = NULL,
  ...
)
}
\arguments{
\item{data}{\emph{Object} from \code{chest_cox}, \code{chest_glm},
\code{chest_speedglm}, \code{chest_lm}, \code{chest_clogit}, or \code{chest_nb},
including effect estimate values and change-in-estimate values.}

\item{no_values}{Suppress effect estimate values in plot, default is FALSE.}

\item{ylab}{Add \code{y} label.}

\item{xlab}{Add \code{x} label.}

\item{change_lab}{\emph{Character} string for the column name of \emph{"Change"} in the graph}

\item{digits}{Set the display format for number in the graph other than the \emph{"Change"} column. Default: "\%.2f"}

\item{digits_change}{Set the format for the \emph{"Change"} column. Default: "\%.1f"}

\item{plus}{Change the \code{+} sign before variable names.}

\item{nudge_y}{Adjust vertical distance between values and point marker.}

\item{nudge_x}{Adjust horizontal distance between values and point marker.}

\item{hjust}{Adjust horizontal alignment.}

\item{height}{Change the height of error bars.}

\item{point_size}{Change point marker size.}

\item{point_shape}{Change point marker shape.}

\item{vline_type}{Change vertical line type.}

\item{vline_color}{Change vertical line color.}

\item{ebar_color}{Change error bar color.}

\item{zero}{x-axis coordinate for vertical non-effect line, see \pkg{forestplot}.}

\item{value_position}{Change the position of value labels.}

\item{...}{Further optional arguments for forestplot.}
}
\value{
a ggplot object.
}
\description{
Plot effect estimate and change-in-estimate values (ggplot type)
}
\examples{
vlist <- c("Age", "Sex", "Married", "Cancer", "CVD", "Education", "Income")
results <- chest_speedglm(
  crude = "Endpoint ~ Diabetes",
  xlist = vlist, na_omit = TRUE, data = diab_df
)
chest_plot(results)
}
\seealso{
\pkg{'ggplot2'}
}
