% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createlms.R
\name{fit_gamlss1}
\alias{fit_gamlss1}
\title{fit_gamlss1}
\usage{
fit_gamlss1(data, age.min = 0, age.max = 80, age.int = 1/12,
  keep.models = F, dist = "BCCGo", formula = NULL,
  sigma.formula = ~1, nu.formula = ~1, tau.formula = ~1,
  method.pb = "ML")
}
\arguments{
\item{data}{dataframe as return by select_meas()}

\item{age.min}{lower bound of age}

\item{age.max}{upper bound of age}

\item{age.int}{stepwidth of the age variable}

\item{keep.models}{indicator whether or not models in each iteration should be kept}

\item{dist}{distribution used for the fitting process, has to be one of BCCGo, BCPEo, BCTo as they are accepted by lms()}

\item{formula}{formula for the location parameter}

\item{sigma.formula}{formula for the sigma parameter}

\item{nu.formula}{formula for the nu parameter}

\item{tau.formula}{formula for the tau parameter}

\item{method.pb}{GAIC or ML}
}
\value{
list containing a dataframe of the fitted lms parameter at the given age points and the fitted model
}
\description{
fit_gamlss
}
\details{
wrapper around the \code{\link[gamlss]{gamlss}} function from the gamlss package
returns the fitted lms-parameter at given age points
the function is called inside \code{\link{do_iterations}} and may not be called directly
}
\author{
Mandy Vogel
}
