\name{Utah_Model}

\alias{Utah_Model}

\title{Calculation of cumulative chill according to the Utah Model}

\description{This function calculates winter chill for temperate trees according to the Utah Model.}

\usage{
Utah_Model(HourTemp,summ=TRUE)
}

\arguments{
  \item{HourTemp}{   Vector of hourly temperatures.}
  \item{summ}{   Boolean parameter indicating whether calculated metrics should be provided as cumulative values over the entire record (TRUE) or as the actual accumulation for each hour (FALSE).}
}
\details{  Units of the Utah Model are calculated as suggested by Richardson et al. (1974) (different weights for different temperature ranges, and negation of chilling by warm temperatures).}

\value{   Vector of length length(HourTemp) containing the cumulative Utah Chill Units over the entire duration of HourTemp.}

\references{
Utah Model reference: 

Richardson EA, Seeley SD, Walker DR (1974) A model for estimating the completion of rest for Redhaven and Elberta peach trees. HortScience 9(4), 331-332
}

\author{Eike Luedeling}

\note{After doing extensive model comparisons, and reviewing a lot of relevant literature, I do not recommend using the Utah Model,
especially in warm climates! The Dynamic Model (Chill Portions), though far from perfect, seems much more reliable.}

\examples{
weather<-fix_weather(KA_weather[which(KA_weather$Year>2006),])

stack<-stack_hourly_temps(weather,latitude=50.4)

Utah_Model(stack$hourtemps$Temp)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ chill and heat calculation }
