\name{step_model}

\alias{step_model}

\title{Calculation of cumulative temperature metric according to a user-defined stepwise weight function}

\description{This function calculates heat for temperate trees according to a stepwise model provided by the user.}

\usage{
step_model(HourTemp,df=data.frame(
                       lower=c(-1000,1.4,2.4,9.1,12.4,15.9,18),
                       upper=c(1.4,2.4,9.1,12.4,15.9,18,1000),
                       weight=c(0,0.5,1,0.5,0,-0.5,-1)),
                         summ=TRUE)
}

\arguments{
  \item{HourTemp}{   Vector of hourly temperatures.}
  \item{df}{   data.frame with three columns: lower, upper and weight. lower should contain the lower boundary of a chilling weight interval and upper should contain the upper boundary. weight indicates the weighting to be applied to the respective temperature interval.}
  \item{summ}{   Boolean parameter indicating whether calculated metrics should be provided as cumulative values over the entire record (TRUE) or as the actual accumulation for each hour (FALSE).}
}
\details{  Temperature-based metric calculated according to the user-defined model.}

\value{   Vector of length length(HourTemp) containing the cumulative temperature metric over the entire duration of HourTemp.}


\author{Eike Luedeling}

\examples{

weather<-fix_weather(KA_weather[which(KA_weather$Year>2006),])

stack<-stack_hourly_temps(weather,latitude=50.4)

df=data.frame(
  lower=c(-1000,1,2,3,4,5,6),
  upper=c(1,2,3,4,5,6,1000),
  weight=c(0,1,2,3,2,1,0))

custom<-function(x) step_model(x,df)

custom(stack$Temp)

models<-list(Chilling_Hours=Chilling_Hours,Utah_Chill_Units=Utah_Model,
Chill_Portions=Dynamic_Model,GDH=GDH,custom=custom)

tempResponse(stack,Start_JDay = 305,End_JDay = 60,models)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ chill and heat calculation }
