% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temperature_scenario_from_records.R
\name{temperature_scenario_from_records}
\alias{temperature_scenario_from_records}
\title{Make monthly temperature scenario from historic records}
\usage{
temperature_scenario_from_records(weather, year, weather_start, weather_end)
}
\arguments{
\item{weather}{daily weather, as produced with the fix_weather
function. Can also be generated by other means, but shouold contain the columns
c("Month","Day","Year","Tmin","Tmax").}

\item{year}{year, for which the scenario is to be produced}

\item{weather_start}{start year of the period to be considered in calculating the regression}

\item{weather_end}{end year of the period to be considered in calculating the regression}
}
\value{
climate scenario object, consisting of the following elements: 'data' = a data frame with
n_intervals elements containing the absolute temperature information. 'reference_year' =
the year the scenario is representative of, i.e. the specified 'year' parameter. 'scenario_type'
= 'absolute' (because this is an absolute temperature scenario, not a relative one);
'labels' = 'and elements attached to the input climate_scenario as an element names 'labels' =
'regression-based scenario'.
}
\description{
Produces a scenario containing monthly means for Tmin and Tmax that are representative
of a particular year. This scenario is computed by applying linear regression to a
file containing Tmin and Tmax records, and using the regression model to calculate typical
values for the user-specified year.
}
\details{
This function produces outputs that can be used as input for the temperature_generation
function. Sample applications are the use of the temperature_generation function for
making replicate weather records for a given year for risk assessment purposes, or
the generation of a weather scenario that can be compared with other datasets (e.g. climate
scenarios based on the WorldClim dataset refer to a 1951-2000 baseline, so that meaningful
use of such scenarios for local contexts requires consideration of a scenario that corresponds
to temperatures in 1975, the central year of this period).
}
\examples{

temperature_scenario_from_records(weather=KA_weather,year=2001,weather_start=2000,weather_end=2005)

 
}
\author{
Eike Luedeling
}
\keyword{utility}
