% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_to_geojson.R
\name{sf_to_geojson}
\alias{sf_to_geojson}
\title{Concatenate a sf object into a geojson polygon}
\usage{
sf_to_geojson(lonlat, dist = 1e-05, nQuadSegs = 2L, ...)
}
\arguments{
\item{lonlat}{an object of class 'sf' and geometry type 'POINT' or 'POLYGON'}

\item{dist}{numeric, buffer distance for all \code{lonlat}}

\item{nQuadSegs}{integer, number of segments per quadrant}

\item{...}{further arguments passed to \code{\link[sf]{sf}} methods}
}
\value{
An object of class 'geosjon' for each row in \code{lonlat}
}
\description{
Take single points from geographical coordinates  and convert it into a
geojson 'Polygon' string using \code{\link[sf:geos_unary]{st_buffer}}.
}
\examples{
\donttest{
# random geographic points within bbox(10, 12, 45, 47)
library("sf")

set.seed(123)
lonlat <- data.frame(lon = runif(5, 10, 12),
                     lat = runif(5, 45, 47))

lonlat <- st_as_sf(lonlat, coords = c("lon","lat"))

gjson <- sf_to_geojson(lonlat)
}
}
\seealso{
Other utility functions: 
\code{\link{dataframe_to_geojson}()}
}
\concept{utility functions}
