% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.geojson.R
\name{as.geojson}
\alias{as.geojson}
\alias{as.geojson.default}
\alias{as.geojson.sf}
\title{Methods to coerce geographical coordinates into a geojson polygon}
\usage{
as.geojson(lonlat, dist = 1e-05, nQuadSegs = 2L, ...)

\method{as.geojson}{default}(lonlat, dist = 1e-05, nQuadSegs = 2L, ...)

\method{as.geojson}{sf}(lonlat, dist = 1e-05, nQuadSegs = 2L, ...)
}
\arguments{
\item{lonlat}{a data.frame or matrix with geographical coordinates lonlat, in 
that order, or an object of class 'sf' and geometry type 'POINT' or 'POLYGON'}

\item{dist}{numeric, buffer distance for all \code{lonlat}}

\item{nQuadSegs}{integer, number of segments per quadrant}

\item{...}{further arguments passed to \code{\link[sf]{sf}} methods}
}
\value{
An object of class 'geosjon' for each row in \code{lonlat}
}
\description{
Take single points from geographical coordinates and coerce it into a
geojson 'Polygon' string
}
\examples{
\donttest{
# Default S3 Method
# random geographic points within bbox(10, 12, 45, 47)
library("sf")

set.seed(123)
lonlat <- data.frame(lon = runif(2, 10, 12),
                     lat = runif(2, 45, 47))

gjson <- as.geojson(lonlat)

#################

# S3 Method for objects of class 'sf'
# random geographic points within bbox(10, 12, 45, 47)
library("sf")

set.seed(123)
lonlat <- data.frame(lon = runif(5, 10, 12),
                     lat = runif(5, 45, 47))

lonlat <- st_as_sf(lonlat, coords = c("lon","lat"))

gjson <- as.geojson(lonlat)
}
}
\concept{utility functions}
