% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-unique.R
\name{chk_unique}
\alias{chk_unique}
\alias{vld_unique}
\alias{chk_named}
\alias{vld_named}
\title{Check/Validate Unique}
\usage{
chk_unique(x, incomparables = FALSE, x_name = NULL)

vld_unique(x, incomparables = FALSE)

chk_named(x, x_name = NULL)

vld_named(x)
}
\arguments{
\item{x}{The object to check.}

\item{incomparables}{A vector of values that cannot be compared.
FALSE means that all values can be compared.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} functions throw an informative error if the test fails.
The \code{vld_} functions return a flag indicating whether the test was met.
}
\description{
Unique checks/validations.
}
\section{Functions}{
\itemize{
\item \code{chk_unique}: Check Unique

Checks if unique using
\code{vld_unique()}.

\item \code{vld_unique}: Validate Unique

Validates if unique using

\code{!anyDuplicated(x, incomparables = incomparables)}.

\item \code{chk_named}: Check Named

Checks if is named using
\code{vld_named()}.

\item \code{vld_named}: Validate Named

Checks if is named using

\code{!is.null(names(x))}.
}}

\examples{

# chk_unique
chk_unique(c(NA, 2))
try(chk_unique(c(NA, NA, 2)))
chk_unique(c(NA, NA, 2), incomparables = NA)

# vld_unique
vld_unique(NULL)
vld_unique(numeric(0))
vld_unique(c(NA, 2))
vld_unique(c(NA, NA, 2))
vld_unique(c(NA, NA, 2), incomparables = NA)

# chk_named
chk_named(c(x = 1))
try(chk_named(list(1)))

# vld_named
vld_named(c(x = 1))
vld_named(list(x = 1))
vld_named(c(x = 1)[-1])
vld_named(list(x = 1)[-1])
vld_named(1)
vld_named(list(1))
}
\seealso{
\code{\link[=anyDuplicated]{anyDuplicated()}}

\code{\link[=is.null]{is.null()}}

\code{\link[=names]{names()}}
}
