% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/streetNameLocator.R
\name{streetNameLocator}
\alias{streetNameLocator}
\title{Locate road by name.}
\usage{
streetNameLocator(road.name, zoom = FALSE, radius = 1)
}
\arguments{
\item{road.name}{Character vector. Note that \code{streetNameLocator}() tries to correct for case and to remove extra spaces.}

\item{zoom}{Logical.}

\item{radius}{Numeric. Controls the degree of zoom. For "radius" <= 5, the anchor case number is plotted.}
}
\value{
A base R graphics plot.
}
\description{
Plots John Snow's map of the 1854 London cholera outbreak and highlights the
selected road. See the list of road names in \code{vignette}("road.names").
}
\examples{
streetNameLocator("Oxford Street")
streetNameLocator("oxford street")
streetNameLocator("Cambridge Street", zoom = TRUE)
streetNameLocator("Cambridge Street", zoom = TRUE, radius = 0)
}
\seealso{
\code{\link{roads}}, \code{\link{road.segments}}, \code{\link{streetNumberLocator}}, \code{vignette("road.names")}
}
