% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/walking.R
\name{neighborhoodWalking}
\alias{neighborhoodWalking}
\title{Compute walking path pump neighborhoods.}
\usage{
neighborhoodWalking(pump.select = NULL, vestry = FALSE,
  weighted = TRUE, case.set = "observed", multi.core = FALSE)
}
\arguments{
\item{pump.select}{Numeric. Vector of numeric pump IDs to define pump neighborhoods (i.e., the "population"). Negative selection possible. \code{NULL} selects all pumps. Note that you can't just select the pump on Adam and Eve Court (#2) because it's technically an isolate.}

\item{vestry}{Logical. \code{TRUE} uses the 14 pumps from the Vestry report. \code{FALSE} uses the 13 in the original map.}

\item{weighted}{Logical. \code{TRUE} computes shortest path weighted by road length. \code{FALSE} computes shortest path in terms of the number of nodes.}

\item{case.set}{Character. "observed", "expected" or "snow". "snow" captures John Snow's annotation of the Broad Street pump neighborhood printed in the Vestry report version of the map.}

\item{multi.core}{Logical or Numeric. \code{TRUE} uses \code{parallel::detectCores()}. \code{FALSE} uses one, single core. You can also specify the number logical cores. On Windows, only \code{multi.core = FALSE} is available.}
}
\value{
An R list with 7 objects:
\itemize{
  \item{\code{paths}: list of paths to nearest or selected pump(s).}
  \item{\code{cases}: list of cases by pump.}
  \item{\code{vestry}: "vestry" from neighborhoodWalking().}
  \item{\code{observed}: "observed" from neighborhoodWalking().}
  \item{\code{pump.select}: "pump.select" from neighborhoodWalking().}
  \item{\code{cores}: number of cores to use for parallel implementation.}
  \item{\code{metric}: incremental metric used to find cut point on split road segments.}
}
}
\description{
Group cases into neighborhoods based on walking distance.
}
\note{
This function is computationally intensive. On a single core of a 2.3 GHz Intel i7, plotting observed paths to PDF takes about 5 seconds while doing so for expected paths takes about 28 seconds. Using the parallel implementation on 4 physical (8 logical) cores, these times fall to about 4 and 11 seconds. Note that parallelization is currently only available on Linux and Mac, and that although some precautions are taken in R.app on macOS, the developers of the 'parallel' package, which \code{neighborhoodWalking()} uses, strongly discourage against using parallelization within a GUI or embedded environment. See \code{vignette("parallel")} for details.
}
\examples{
\dontrun{

neighborhoodWalking()
neighborhoodWalking(pump.select = -6)
}
}
