% Generated by roxygen2 (4.0.2): do not edit by hand
\name{choroplethr_animate}
\alias{choroplethr_animate}
\title{Animate a list of chropleths}
\usage{
choroplethr_animate(choropleths)
}
\arguments{
\item{choropleths}{A list of choropleths represented as ggplot2 objects.}
}
\value{
Nothing.  However, a variable number of files are written to the current working directory.
}
\description{
Given a list of choropleths, represented as ggplot2 objects
\enumerate{
\item Save the individual images to the working directory with the naming convention "choropleth_1.png", "choropleth_2.png", etc.
\item Write a file called "animated_choropleth.html" which contains a viewer which animates them.
}
}
\examples{
\dontrun{
data(df_president_ts)
?df_president_ts # time series of all US presidential elections 1789-2012

# create a list of choropleths of presidential election results for each year
choropleths = list()
for (i in 1:(ncol(df_president_ts)-1)) {
  df           = df_president_ts[, c(ncol(df_president_ts), i)]
  colnames(df) = c("region", "value")
  title        = paste0("Presidential Election Results: ", colnames(df_president_ts)[i])
 choropleths[[i]] = state_choropleth(df, title=title)
}

# set working directory and animate
setwd("~/Desktop")
choroplethr_animate(choropleths)
}
}
\author{
Ari Lamstein (R code) and Brian Johnson (JavaScript, HTML and CSS code)
}
\keyword{animation}
\keyword{choropleth}

