% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{df_county_demographics}
\alias{df_county_demographics}
\title{A data.frame containing demographic statistics for each county in the United States.}
\usage{
data(df_county_demographics)
}
\description{
A data.frame containing demographic statistics for each county in the United States.
}
\examples{
\donttest{
library(choroplethr)
data(df_county_demographics)

# examine the 2013, 5-year county percent hispanic estimates as a boxplot and choropleth

# the boxplot shows the distribution
boxplot(df_county_demographics$percent_hispanic)

# the choropleth map shows the location of the values
# first set the 'value' column to be the column we want to render
df_county_demographics$value = df_county_demographics$percent_hispanic
county_choropleth(df_county_demographics)
}
}
\references{
Data comes from the 2013 5-year American Community Survey (ACS). Data generated by
?get_county_demographics.
}
\keyword{data}
