% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{data}
\name{state.map}
\alias{state.map}
\title{Map of the 50 US states plus the district of columbia.}
\usage{
data(state.map)
}
\description{
A data.frame which contains a map of all 50 US States plus
the District of Columbia.  The shapefile
was modified using QGIS in order to 1) remove
Puerto Rico and 2) remove islands off of Alaska that
crossed the antimeridian 3) renamed column "STATE" to "region".
}
\examples{
\dontrun{
# render the map with ggplot2
library(ggplot2)

data(state.map)
ggplot(state.map, aes(long, lat, group=group)) + geom_polygon()
}
}
\references{
Taken from the US Census 2010
Cartographic Boundary shapefiles page (https://www.census.gov/geo/maps-data/data/tiger-cart-boundary.html) in May 2014.
The resolutions is 20m (20m = 1:20,000,000).
}

