% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_interface.R
\name{render_report}
\alias{render_report}
\title{Render the report using current environment}
\usage{
render_report(
  report,
  filename = "Chronicle report",
  directory = getwd(),
  keep_rmd = FALSE,
  render_html = TRUE,
  render_pdf = FALSE
)
}
\arguments{
\item{report}{The caracter string created by chronicle functions}

\item{filename}{The name of the .html created}

\item{directory}{The directory in which to render the .html report}

\item{keep_rmd}{Whether or not to keep the .Rmd file. Default is false.}

\item{render_html}{Whether or not to render the report as an interactive hmtl file.}

\item{render_pdf}{Whether or not to render the report as a PDF file. Keep in mind that while the file will be much more lightweight, you will lose all the interactivity the html provides.}
}
\value{
Renders the report as an HTML file.
}
\description{
Render the report using current environment
}
\examples{
library(chronicle)
library(magrittr)
new_report() \%>\% render_report(filename = 'test_report')
file.remove('test_report.html')
}
