% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cifplot.R
\name{cifplot}
\alias{cifplot}
\title{Generate a survival/CIF curve with marks that represent
censoring, competing risks and intercurrent events}
\usage{
cifplot(
  formula_or_fit,
  data = NULL,
  weights = NULL,
  subset.condition = NULL,
  na.action = na.omit,
  outcome.type = c("competing-risk", "survival"),
  code.event1 = 1,
  code.event2 = 2,
  code.censoring = 0,
  code.events = NULL,
  error = NULL,
  conf.type = "arcsine-square root",
  conf.int = 0.95,
  type.y = NULL,
  label.x = "Time",
  label.y = NULL,
  label.strata = NULL,
  level.strata = NULL,
  order.strata = NULL,
  limits.x = NULL,
  limits.y = NULL,
  breaks.x = NULL,
  breaks.y = NULL,
  use.coord.cartesian = FALSE,
  add.conf = TRUE,
  add.risktable = TRUE,
  add.estimate.table = FALSE,
  symbol.risk.table = "square",
  font.size.risk.table = 3,
  add.censor.mark = TRUE,
  shape.censor.mark = 3,
  size.censor.mark = 2,
  add.competing.risk.mark = FALSE,
  competing.risk.time = list(),
  shape.competing.risk.mark = 16,
  size.competing.risk.mark = 2,
  add.intercurrent.event.mark = FALSE,
  intercurrent.event.time = list(),
  shape.intercurrent.event.mark = 1,
  size.intercurrent.event.mark = 2,
  add.quantile = FALSE,
  level.quantile = 0.5,
  panel.per.event = FALSE,
  panel.censoring = FALSE,
  panel.per.variable = FALSE,
  panel.mode = "auto",
  rows.columns.panel = NULL,
  style = "classic",
  palette = NULL,
  linewidth = 0.8,
  linetype = FALSE,
  font.family = "sans",
  font.size = 12,
  legend.position = "top",
  print.panel = FALSE,
  filename.ggsave = NULL,
  width.ggsave = 6,
  height.ggsave = 6,
  dpi.ggsave = 300,
  survfit.info = NULL,
  axis.info = NULL,
  visual.info = NULL,
  panel.info = NULL,
  style.info = NULL,
  inset.info = NULL,
  print.info = NULL,
  ggsave.info = NULL,
  ...
)
}
\arguments{
\item{formula_or_fit}{Either a model formula or a survfit object. When a formula is
supplied, the LHS must be \code{Event(time, status)} or \code{Surv(time, status)}.
The RHS specifies an optional stratification variable.}

\item{data}{A data frame containing variables in the formula.}

\item{weights}{Optional name of the weight variable in \code{data}. Weights must be nonnegative.}

\item{subset.condition}{Optional character string giving a logical condition to subset
\code{data} (default \code{NULL}).}

\item{na.action}{A function specifying the action to take on missing values (default \code{na.omit}).}

\item{outcome.type}{Character string specifying the type of time-to-event outcome.
One of \code{"survival"} (Kaplan-Meier) or \code{"competing-risk"} (Aalen-Johansen).
If \code{NULL} (default), the function automatically infers the outcome type from the data:
if the event variable has more than two unique levels, \code{"competing-risk"} is assumed;
otherwise, \code{"survival"} is used. You can also use abbreviations such as \code{"S"} or \code{"C"}.
Mixed or ambiguous inputs (e.g., \code{c("S", "C")}) trigger automatic detection based on the event coding.}

\item{code.event1}{Integer code of the event of interest (default \code{1}).}

\item{code.event2}{Integer code of the competing risk (default \code{2}).}

\item{code.censoring}{Integer code of censoring (default \code{0}).}

\item{code.events}{Optional numeric length-3 vector \code{c(event1, event2, censoring)}.
When supplied, it overrides \code{code.event1}, \code{code.event2}, and \code{code.censoring}
(primarily used when \code{\link[=cifpanel]{cifpanel()}} is called or when \code{panel.per.event = TRUE}).}

\item{error}{Character string specifying the method for SEs and CIs used internally.
For \code{"survival"} without weights, choose one of \code{"greenwood"} (default), \code{"tsiatis"}, or \code{"if"}.
For \code{"competing-risk"} without weights, choose one of \code{"delta"} (default), \code{"aalen"}, or \code{"if"}.
SEs and CIs based on influence functions (\code{"if"}) is recommended for weighted analysis.}

\item{conf.type}{Character specifying the method of transformation for CIs
used internally (default \verb{arcsine-square root}).}

\item{conf.int}{Numeric two-sided level of CIs (default \code{0.95}).}

\item{type.y}{Character string specifying the y-scale. For survival/CIF curves,
\code{"surv"} implies survival probabilities and \code{"risk"} implies CIF
(1-survival in simple survival settings). Specify \code{"cumhaz"} to plot cumulative hazard
or \code{"cloglog"} to generate a complementary log-log plot.
If \code{NULL}, a default is chosen from \code{outcome.type} or the survfit object.}

\item{label.x}{Character x-axis label (default \code{"Time"}).}

\item{label.y}{Character y-axis label (default is chosen automatically from \code{outcome.type}
and \code{type.y}, e.g. "Survival", "Cumulative incidence" or "Cumulative hazard").}

\item{label.strata}{Character vector or named character vector specifying labels for strata.
Names (if present) must match the (re-ordered) underlying strata levels.
\strong{Note:} when any of the panel modes is active
(\code{panel.per.variable = TRUE}, \code{panel.per.event = TRUE}, \code{panel.censoring = TRUE},
or \code{panel.mode = "auto"} and it actually dispatches to a panel),
strata labels are suppressed to avoid duplicated legends across sub-plots.}

\item{level.strata}{Optional character vector giving the full set of expected strata levels.
When provided, both \code{order.strata} and \code{label.strata} are validated against it
before application.}

\item{order.strata}{Optional character vector specifying the display order of strata
in the legend/number-at-risk table. Specify the levels of strata. Levels not listed are dropped.}

\item{limits.x}{Numeric length-2 vector specifying x-axis limits. If \code{NULL}, it is
set from the fitted object (typically \code{c(0, max(time))}).}

\item{limits.y}{Numeric length-2 vector specifying y-axis limits. If \code{NULL}, it is
set to \code{c(0, 1)} for probability-type outcomes.}

\item{breaks.x}{Numeric vector of x-axis breaks (default \code{NULL}).}

\item{breaks.y}{Numeric vector of y-axis breaks (default \code{NULL}).}

\item{use.coord.cartesian}{Logical; if \code{TRUE}, uses \code{ggplot2::coord_cartesian()} for zooming
instead of changing the scale limits (default \code{FALSE}).}

\item{add.conf}{Logical; if \code{TRUE}, adds a CI ribbon
(via \code{ggsurvfit::add_confidence_interval()}). Default \code{TRUE}.}

\item{add.risktable}{Logical; if \code{TRUE}, adds a numbers-at-risk table under the plot.
Default \code{TRUE}. \strong{Note:} when a panel mode is active, tables are suppressed.}

\item{add.estimate.table}{Logical; if \code{TRUE}, adds a table of estimates and CIs.
Default \code{FALSE}. \strong{Note:} when a panel mode is active, tables are suppressed.}

\item{symbol.risk.table}{Character specifying the symbol used in the risk table to denote
strata: \code{"square"}, \code{"circle"}, or \code{"triangle"} (default \code{"square"}).}

\item{font.size.risk.table}{Numeric font size for texts in risk / estimate tables (default \code{3}).}

\item{add.censor.mark}{Logical; if \code{TRUE}, draws censoring marks on each curve
(via \code{ggsurvfit::add_censor_mark()}). Default \code{TRUE}.}

\item{shape.censor.mark}{Integer point shape used for censoring marks (default \code{3}).}

\item{size.censor.mark}{Numeric point size used for censoring marks (default \code{2}).}

\item{add.competing.risk.mark}{Logical; if \code{TRUE}, draws time marks for the competing event
(event 2). If no times are supplied via \code{competing.risk.time}, the function tries to
extract them automatically from the data. Default \code{FALSE}.}

\item{competing.risk.time}{A \strong{named list} of numeric vectors. Each name must correspond to a
strata label, and its numeric vector gives the times at which the competing event occurred
in that stratum. Typically left as \code{list()} and filled internally.}

\item{shape.competing.risk.mark}{Integer point shape for competing-risk marks (default \code{16}).}

\item{size.competing.risk.mark}{Numeric point size for competing-risk marks (default \code{2}).}

\item{add.intercurrent.event.mark}{Logical; if \code{TRUE}, overlays user-specified intercurrent-event
times per stratum. Default \code{FALSE}.}

\item{intercurrent.event.time}{A \strong{named list} of numeric vectors for intercurrent events
(names must match strata labels).}

\item{shape.intercurrent.event.mark}{Integer point shape for intercurrent-event marks
(default \code{1}).}

\item{size.intercurrent.event.mark}{Numeric point size for intercurrent-event marks
(default \code{2}).}

\item{add.quantile}{Logical; if \code{TRUE}, adds a quantile reference line (via
\code{ggsurvfit::add_quantile()}). Default \code{FALSE}.}

\item{level.quantile}{Numeric quantile level to be shown (default \code{0.5} for the median).}

\item{panel.per.event}{Logical. \strong{Explicit panel mode.} If \code{TRUE} and
\code{outcome.type == "competing-risk"}, \code{\link[=cifplot]{cifplot()}} internally calls \code{\link[=cifpanel]{cifpanel()}}
to display two event-specific CIFs side-by-side (event 1 and event 2) using
reversed \code{code.events}. Ignored for non-competing-risk outcomes.}

\item{panel.censoring}{Logical. \strong{Explicit panel mode.} If \code{TRUE} and
\code{outcome.type == "survival"}, \code{\link[=cifplot]{cifplot()}} internally calls \code{\link[=cifpanel]{cifpanel()}}
to display KM curves for \verb{(event, censor)} and \verb{(censor, event)} so that
censoring patterns can be inspected.}

\item{panel.per.variable}{Logical. \strong{Explicit panel mode.} If \code{TRUE} and the RHS
of the formula has multiple covariates (e.g. \code{~ a + b + c}), the function produces
a panel where each variable in the RHS is used once as the stratification factor.}

\item{panel.mode}{Character specifying \strong{Automatic panel mode.} If \code{"auto"} and none of
\code{panel.per.variable}, \code{panel.per.event}, \code{panel.censoring} has been set to \code{TRUE},
the function chooses a suitable panel mode automatically:
(i) if the formula RHS has 2+ variables, it behaves like \code{panel.per.variable = TRUE};
(ii) otherwise, if \code{outcome.type == "competing-risk"}, it behaves like
\code{panel.per.event = TRUE}; (iii) otherwise, if \code{outcome.type == "survival"}, it
behaves like \code{panel.censoring = TRUE}. If a panel mode is explicitly specified,
\code{panel.mode} is ignored.}

\item{rows.columns.panel}{Optional integer vector \code{c(nrow, ncol)} controlling
the layout of the panel returned by the panel modes. If \code{NULL}, an automatic
layout is determined from the number of subplots.}

\item{style}{Character choosing the base plot style: \code{"classic"}, \code{"bold"},
\code{"framed"}, \code{"grid"}, \code{"gray"} or \code{"ggsurvfit"} (default \code{"classic"}).
Abbreviations such as \code{"C"}, \code{"B"}, \code{"F"}, or \code{"G"} are also accepted.}

\item{palette}{Optional character vector specifying the color palette to use across strata.}

\item{linewidth}{Optional numeric specifying the line width of curve (default \code{0.8}).}

\item{linetype}{Optional logical using different line types of curve (default \code{FALSE}).}

\item{font.family}{Character specifying the font family: \code{"sans"},  \code{"serif"}, or
\code{"mono"} (default \code{"sans"}).}

\item{font.size}{Integer specifying the base font size (default \code{12}).}

\item{legend.position}{Character specifying the legend position:
\code{"top"}, \code{"right"}, \code{"bottom"}, \code{"left"}, or \code{"none"} (default \code{"top"}).}

\item{print.panel}{Logical. When \code{TRUE}, panel displays created internally are
printed automatically in interactive sessions; otherwise they are returned
invisibly for further modification (default \code{FALSE}).}

\item{filename.ggsave}{Character; if non-\code{NULL}, save the plot to this file.}

\item{width.ggsave}{Numeric width passed to \code{ggplot2::ggsave()} (default \code{6}).}

\item{height.ggsave}{Numeric height passed to \code{ggplot2::ggsave()} (default \code{6}).}

\item{dpi.ggsave}{Numeric DPI passed to \code{ggplot2::ggsave()} (default \code{300}).}

\item{survfit.info, axis.info, visual.info, panel.info, style.info, print.info, ggsave.info}{Internal lists used for programmatic control. Not intended for direct user input.}
}
\value{
A \code{"cifplot"} object (a list) with at least the following elements:
\itemize{
\item \code{plot}: a ggplot object containing the main plot
\item \code{patchwork}: reserved for compatibility with panel displays
(typically \code{NULL} for single-panel plots)
\item \code{survfit.info}, \code{axis.info}, \code{visual.info}, \code{panel.info},
\code{style.info}, \code{inset.info}, \code{print.info}, \code{ggsave.info}:
internal lists storing the fitted curves and display settings
\item \code{version}: a character string giving the cifmodeling version used
\item \code{call}: the original function call
}

The object is returned invisibly. When a panel mode is active and
\code{print.panel = TRUE}, the panel is also printed in interactive sessions.
}
\description{
This function generates a survival or CIF curve from a unified formula–data
interface or from an existing survfit object. When a formula is supplied,
the LHS is typically \code{Event()} or \code{survivai::Surv()}, and the RHS specifies
an optional stratification variable. In addition to the curves themselves,
\code{\link[=cifplot]{cifplot()}} can add numbers-at-risk tables, tables of point estimates and
CIs, censoring marks, competing-risk marks, and intercurrent-event marks.

For more complex multi-panel displays, \code{\link[=cifplot]{cifplot()}} can internally call
\code{\link[=cifpanel]{cifpanel()}} via several “panel modes” (per event, per variable, or
censoring-focused). The function returns an object whose \code{plot} component
is a regular ggplot object that can be further modified (compatible with \code{+} and \verb{\%+\%}).
}
\details{
\subsection{Typical use cases}{
\itemize{
\item Draw one survival/CIF curve set by exposure groups (e.g., treatment vs control).
\item Call \code{cifpanel()} with a simplified code to create a panel displaying plots of multiple stratified survival/CIF curves or CIF curves for each event type.
\item Add CIs and censor/competing-risk/intercurrent-event marks.
\item Add number-at-risk table to display the number at risk or the estimated survival probabilities or CIFs and CIs at each point in time.
}
}

\subsection{Key arguments shared with cifcurve()}{
\itemize{
\item \strong{Outcome type and estimator}
\itemize{
\item \code{outcome.type = "survival"}: Kaplan-Meier estimator
\item \code{outcome.type = "competing-risk"}: Aalen-Johansen estimator
}
\item \strong{Confidence intervals}
\itemize{
\item \code{conf.int} sets the two-sided level (default 0.95)
\item \code{conf.type} chooses the transformation (\code{"arcsine-square root"}, \code{"plain"}, \code{"log"}, \code{"log-log"}, \code{"logit"}, or \code{"none"})
\item \code{error} chooses the estimator for SE (\code{"greenwood"}, \code{"tsiatis"} or \code{"if"} for survival curves and \code{"delta"}, \code{"aalen"} or \code{"if"} for CIFs)
}
}
}

\subsection{Key arguments for cifplot()}{
\itemize{
\item \strong{Data visualization}
\itemize{
\item \code{add.conf} adds CIs on the ggplot2-based plot
\item \code{add.competing.risk.mark} and \code{add.intercurrent.event.mark} adds symbols to describe competing risks or intercurrent events in addition to conventional censoring marks with \code{add.censor.mark}
\item \code{add.risktable} adds numbers at risk
\item \code{add.estimate.table} adds time-by-time estimates and CIs
\item \code{add.quantile} adds a reference line at a chosen quantile level
}
\item \strong{Plot customization}
\itemize{
\item \code{type.y} chooses y-axis (\code{"surv"} for survival and \code{"risk"} for 1-survival/CIF)
\item \code{limits.x}, \code{limits.y}, \code{breaks.x}, \code{breaks.y}: numeric vectors for axis control
\item \code{style} specifies the appearance of plot (\code{"classic"}, \code{"bold"}, \code{"framed"}, \code{"grid"}, \code{"gray"} or \code{"ggsurvfit"})
\item \code{palette} specifies color of each curve (e.g. \verb{palette=c("blue1", "cyan3", "navy", "deepskyblue3"))})
}
\item \strong{Panel display}
\itemize{
\item \code{panel.per.variable} produces multiple survival/CIF curves per stratification variable specified in the formula
\item \code{panel.per.event} produces CIF curves for each event type
\item \code{panel.censoring} produces the Kaplan–Meier curves for (event, censor) and (censor, event) so that censoring patterns can be inspected
\item \code{panel.mode} uses automatic panel mode
}
}

When \code{panel.per.event = TRUE}, two panels are created with
\code{code.events = list(c(e1, e2, c), c(e2, e1, c))}, where
\code{code.events = c(e1, e2, c)} is the input coding for event1, event2, and censoring.
Common legend is collected by default (\code{legend.collect = TRUE}).

Numeric stratification variables are normalized automatically. Columns with
fewer than nine distinct numeric values are coerced to factors; columns with
nine or more distinct numeric values are split at the median into
\dQuote{Below median} and \dQuote{Above median} strata.
}

\subsection{Advanced control not required for typical use}{

The arguments below fine-tune internal estimation and figure appearance.
\strong{Most users do not need to change these defaults.}
\subsection{Graphical layers}{\tabular{lll}{
   Argument \tab Description \tab Default \cr
   \code{add.conf} \tab Add confidence interval ribbon. \tab \code{TRUE} \cr
   \code{add.risktable} \tab Add numbers-at-risk table below the plot. \tab \code{TRUE} \cr
   \code{add.estimate.table} \tab Add estimates and confidence intervals table. \tab \code{FALSE} \cr
   \code{symbol.risk.table} \tab Symbol for strata in risk / estimate tables \tab \code{"square"} \cr
   \code{font.size.risk.table} \tab Font size for texts in risk / estimate tables \tab \code{3} \cr
   \code{add.censor.mark} \tab Add censoring marks. \tab \code{TRUE} \cr
   \code{add.competing.risk.mark} \tab Add marks for event2 of "competing-risk" outcome. \tab \code{FALSE} \cr
   \code{add.intercurrent.event.mark} \tab Add intercurrent event marks at user-specified times. \tab \code{FALSE} \cr
   \code{add.quantile} \tab Add quantile reference lines. \tab \code{FALSE} \cr
   \code{level.quantile} \tab Quantile level for \code{add.quantile}. \tab \code{0.5} \cr
}

}

\subsection{Time for marks}{\tabular{ll}{
   Argument \tab Description \cr
   \code{competing.risk.time} \tab \strong{Named list} of numeric vectors that contains times of competing risks. Names must match strata labels. Typically created internally \cr
   \code{intercurrent.event.time} \tab \strong{Named list} of numeric vectors that contains times of intercurrent events. Names must match strata labels. Typically created by \code{extract_time_to_event()}. \cr
}

}

\subsection{Appearance of marks}{\tabular{lll}{
   Argument \tab Applies to \tab Default \cr
   \code{shape.censor.mark} \tab Censoring marks \tab \code{3} (cross) \cr
   \code{size.censor.mark} \tab Censoring marks \tab \code{2} \cr
   \code{shape.competing.risk.mark} \tab Competing-risk marks \tab \code{16} (filled circle) \cr
   \code{size.competing.risk.mark} \tab Competing-risk marks \tab \code{2} \cr
   \code{shape.intercurrent.event.mark} \tab Intercurrent marks \tab \code{1} (circle) \cr
   \code{size.intercurrent.event.mark} \tab Intercurrent marks \tab \code{2} \cr
}

}

\subsection{Panel display}{\tabular{ll}{
   Argument \tab Description \cr
   \code{panel.per.variable} \tab One panel per stratification variable \cr
   \code{panel.per.event} \tab For \code{"competing-risk"}, show CIFs of event 1 and event 2 \cr
   \code{panel.censoring} \tab For survival, show (event, censor) vs (censor, event) \cr
   \code{panel.mode} with 2+ stratification variables \tab Behave like \code{panel.per.variable} \cr
   \code{panel.mode} with outcome.type = "competing-risk" \tab Behave like \code{panel.per.event} \cr
   \code{panel.mode} with outcome.type = "survival" \tab Behave like \code{panel.censoring} \cr
}

}

\subsection{Axes and legend}{\tabular{lll}{
   Argument \tab Description \tab Default \cr
   \code{limits.x}, \code{limits.y} \tab Axis limits (\code{c(min, max)}) \tab Auto \cr
   \code{breaks.x}, \code{breaks.y} \tab Tick breaks for x and y axes \tab Auto \cr
   \code{use.coord.cartesian} \tab For zooming use \code{coord_cartesian()} \tab \code{FALSE} \cr
   \code{legend.position} \tab \code{"top"}, \code{"right"}, \code{"bottom"}, \code{"left"}, \code{"none"} \tab \code{"top"} \cr
}

}

\subsection{Export}{\tabular{lll}{
   Argument \tab Description \tab Default \cr
   \code{filename.ggsave} \tab If non-\code{NULL}, save the plot using \code{ggsave()} \tab \code{NULL} \cr
   \code{width.ggsave} \tab Size passed to \code{ggsave()} \tab \code{6} \cr
   \code{height.ggsave} \tab Size passed to \code{ggsave()} \tab \code{6} \cr
   \code{dpi.ggsave} \tab DPI passed to \code{ggsave()} \tab \code{300} \cr
}


\strong{Notes}
\itemize{
\item For CIF displays, set \code{type.y = "risk"}. For survival scale, use \code{type.y = NULL} or \verb{= "surv"}.
For a cumulative hazard plot, use \code{type.y = "cumhaz"}. To generate a log-log plot, use \code{type.y = "cloglog"}.
\item Event coding can be controlled via \code{code.event1}, \code{code.event2}, \code{code.censoring}.
For ADaM-style data, use \code{code.event1 = 0}, \code{code.censoring = 1}.
\item Per-stratum time lists should have names identical to plotted strata labels.
}
}

}
}
\section{Lifecycle}{

\lifecycle{stable}
}

\examples{
data(diabetes.complications)
cifplot(Event(t,epsilon) ~ fruitq,
        data = diabetes.complications,
        outcome.type="competing-risk",
        add.risktable = FALSE,
        label.y='CIF of diabetic retinopathy',
        label.x='Years from registration')

}
\seealso{
\code{\link[=polyreg]{polyreg()}} for log-odds product modeling of CIFs; \code{\link[=cifcurve]{cifcurve()}} for KM/AJ estimators; \code{\link[=cifpanel]{cifpanel()}} for display of multiple CIFs; \link[ggsurvfit:ggsurvfit]{ggsurvfit::ggsurvfit}, \link[patchwork:patchwork-package]{patchwork::patchwork} and \link[modelsummary:modelsummary]{modelsummary::modelsummary} for display helpers.
}
\keyword{internal}
