% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{merge_kwargs}
\alias{merge_kwargs}
\title{Merges two kwargs}
\usage{
merge_kwargs(
  kwargsA,
  kwargsB,
  labelA = "first kwarg(s)",
  labelB = "second kwarg(s)",
  extraMsg = "[DEFAULT]"
)
}
\arguments{
\item{kwargsA}{The first list of kwargs.}

\item{kwargsB}{The second list of kwargs. If duplicates are present, the default
message recommends the user to remove the kwarg here in favor of placing the
correct one in \code{kwargsA}.}

\item{labelA}{(Optional) Descriptor of \code{kwargsA} for error statement. Default "first kwarg(s)".}

\item{labelB}{(Optional) Descriptor of \code{kwargsB} for error statement. Default "second kwarg(s)".}

\item{extraMsg}{(Optional) Extra text for error statement. "[DEFAULT]" (default) will use this message:
"Note that a kwarg only has to be provided to one of these. Place the correct value in the first
location and remove the kwarg from the second location".}
}
\value{
A list with the union of \code{kwargsA} and \code{kwargsB}
}
\description{
Merge two kwarg lists. If a kwarg is present in both lists but with different
 values, an error is raised.
}
\keyword{internal}
