% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_cifti.R
\name{write_cifti}
\alias{write_cifti}
\alias{writeCIfTI}
\alias{writecii}
\alias{write_xifti}
\title{Write a CIFTI file from a \code{"xifti"} object.}
\usage{
write_cifti(
  xifti,
  cifti_fname,
  surfL_fname = NULL,
  surfR_fname = NULL,
  verbose = TRUE
)

writeCIfTI(
  xifti,
  cifti_fname,
  surfL_fname = NULL,
  surfR_fname = NULL,
  verbose = TRUE
)

writecii(
  xifti,
  cifti_fname,
  surfL_fname = NULL,
  surfR_fname = NULL,
  verbose = TRUE
)

write_xifti(
  xifti,
  cifti_fname,
  surfL_fname = NULL,
  surfR_fname = NULL,
  verbose = TRUE
)
}
\arguments{
\item{xifti}{Object of class "xifti".
See \code{\link{is.xifti}} and \code{\link{make_xifti}}.}

\item{cifti_fname}{File path of CIFTI-format data (ending in ".d*.nii").}

\item{surfL_fname, surfR_fname}{If the [left/right] surface is present, it
will be a written to a GIFTI file at this file path. If \code{NULL}
(default), do not write out the surface.}

\item{verbose}{Should occasional updates be printed? Default: \code{TRUE}.}
}
\value{
Named character vector of the written files
}
\description{
Write out a \code{"xifti"} object as a CIFTI file and (optionally) GIFTI
surface files.
}
\section{Connectome Workbench Requirement}{

This function uses a system wrapper for the 'wb_command' executable. The
user must first download and install the Connectome Workbench, available
from https://www.humanconnectome.org/software/get-connectome-workbench .
}

