% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.r
\name{DRshrink}
\alias{DRshrink}
\title{Shrinkage fix to bias in observed rates under adaptive dose-finding design}
\usage{
DRshrink(y, x = NULL, wt0 = NULL, target, swt = 1, nmin = 2, ...)
}
\arguments{
\item{y}{can be either of the following: y values (response rates), a 2-column matrix with positive/negative response counts by dose, a \code{\link{DRtrace}} object or a \code{\link{doseResponse}} object.}

\item{x}{dose levels (if not included in y).}

\item{wt0}{weights (if not included in y).}

\item{target}{the balance point (between 0 and 1) around which the design concentrates allocations.}

\item{swt}{the weight of the shrinkage. Default 1 (a single observation)}

\item{nmin}{the minimum n at each dose, for the shrinkage to be applied. Default 1 (all doses with any observation).}

\item{...}{parameters passed on to \code{doseResponse()}}
}
\description{
Adaptive dose-finding designs induce a bias on observed rates,
away from the target dose. This is well-known in other adaptive-design fields,
but has been overlooked by the dose-finding research community.
Flournoy and Oron (2020) examine the bias in the dose-finding context,
and suggest a simple shrinkage fix that reduces both bias and variance.
The fix is analogous to the empirical-logit fix to binary data, 
but instead of adding 0.5 to each cell, \code{target} is added to the 1's at each dose, 
and \code{1-target} to the 0's.
The shrinkage is applied to the raw observation, so CIR or IR are carried out
on the shrunk data.
}
\references{
Flournoy N and Oron AP, 2020. Bias Induced by Adaptive Dose-Finding Designs. Journal of Applied Statistics 47, 2431-2442.
}
\author{
Assaf P. Oron \code{<assaf.oron.at.gmail.com>}
}
