% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.r
\name{is.DRtrace}
\alias{is.DRtrace}
\alias{is.doseResponse}
\alias{DRtrace}
\alias{doseResponse}
\title{Constructor functions and class-checking functions for DRtrace and doseResponse classes}
\usage{
is.DRtrace(dr)

is.doseResponse(dr)

DRtrace(y, x = NULL, wt = NULL, noyes = FALSE, ...)

doseResponse(y, x = NULL, wt = rep(1, length(y)), noyes = FALSE, ...)
}
\arguments{
\item{dr}{the object being checked}

\item{y, x, wt}{see Details.}

\item{noyes}{logical, in case of a 2-column input is the 1st column 'no'? Default \code{FALSE}, meaning the 1st column is 'yes'.}

\item{...}{parameters passed on to \code{DRtrace()}, or ignored.}
}
\value{
For constructor functions, the relevant object. For checking functions, a logical value indicating whether the object meets class definition.
}
\description{
Functions to create and sanity-check objects of the \code{DRtrace} (dose-response experiment trace/trajectory) and \code{doseResponse} (dose-response raw summary) classes. Note that the latter inherits from the former, purely for programming-convenience reasons.
}
\details{
The input argument \code{y} can include the entire information, or as little as the \code{y} vector of responses (for a \code{DRtrace} object) or response rates (\code{doseResponse}). When including the entire information, it has to be a data frame with at least \code{y} (both y and x for \code{DRtrace}), or a two-column matrix with 'yes' and 'no' responses (assumed in this order, but can be the reverse with \code{noyes=TRUE}). In this case the doses \code{x} can be provided as a separate vector, or as the matrix row names. \code{doseResponse} will return an error if there are any duplicates in \code{x}.

Even though both \code{DRtrace} and \code{doseResponse} accept two-column yes/no matrix input, the interpretation is different. For the former, this form of input is intended mostly to enable shorthand input when the experiment was run in cohorts. Each row represents a cohort's results, and rows must be in the order the experiment was run. For the latter, the yes-no table is a summary tabulation of responses and is treated accordingly, including rearrangement of rows to increasing \code{x}.
}
\examples{
## Summary of raw data from the notorious Neuenschwander et al. (Stat. Med., 2008) trial
neundatTrace=DRtrace(x=c(rep(1:4,each=4),7,7,rep(6,9)),y=c(rep(0,16),1,1,rep(c(0,0,1),2),0,0,0))
par(mar=c(3,3,3,1),mgp=c(2,.5,0),tcl=-0.25)
layout(t(1:2))
plot(neundatTrace,main="N. et al. (2008) Cohort Trace",ylab="Ordinal Dose Level",cex.main=1.5)

## Same data, in 'doseResponse' format with actual doses rather than dose levels
neundatDose=doseResponse(x=c(1,2.5,5,10,20,25),y=c(rep(0,4),2/9,1),wt=c(3,4,5,4,9,2))
plot(neundatDose,main="N. et al. (2008) Final Dose-Toxicity",ylim=c(0,1),
	xlab="Dose (mg/sq.m./wk)",ylab="Toxicity Response Curve (F)",cex.main=1.5)
## We can also convert the DRtrace object to doseResponse...
neundatLevel=doseResponse(neundatTrace)

### Now plotting the former, vs. IR/CIR estimates
neunCIR0=cirPAVA(neundatDose,full=TRUE)
lines(neunCIR0$shrinkage$x,neunCIR0$shrinkage$y,type='b',pch=19)
legend(1,1,pch=c(4,19),legend=c('Observations','CIR (IR is same)'),bty='n')
}
\seealso{
\code{\link{cirPAVA}}, \code{\link{plot.doseResponse}},\code{\link{plot.DRtrace}}
}
\author{
Assaf P. Oron \code{<assaf.oron.at.gmail.com>}
}
