% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track.R
\name{ccTrack}
\alias{ccTrack}
\title{Define a generic track}
\usage{
ccTrack(
  sectors = NULL,
  x = NULL,
  y = NULL,
  ylim = NULL,
  force.ylim = TRUE,
  track.index = NULL,
  track.height = circos.par("track.height"),
  track.margin = circos.par("track.margin"),
  cell.padding = circos.par("cell.padding"),
  bg.col = NA,
  bg.border = "black",
  bg.lty = par("lty"),
  bg.lwd = par("lwd"),
  panel.fun = function(x, y) {
     NULL
 },
  factors = sectors
)
}
\arguments{
\item{sectors}{A \code{\link{factor}} or a character vector which represents categories of data, if it is \code{NULL}, then it uses all sector index.}

\item{x}{Data on x-axis. It is only used if \code{panel.fun} is set.}

\item{y}{Data on y-axis}

\item{ylim}{Range of data on y-axis}

\item{force.ylim}{Whether to force all cells in the track to share the same \code{ylim}. Normally, all cells on a same track should have same \code{ylim}.}

\item{track.index}{Index for the track which is going to be created/updated. If the specified track has already been created, this function just updated corresponding track with new plot. If the specified track is \code{NULL} or has not been created, this function just creates it. Note the value for this argument should not exceed maximum track index plus 1.}

\item{track.height}{Height of the track. It is the percentage to the radius of the unit circles. The value can be set by \code{\link[circlize]{uh}} to an absolute unit. If updating a track (with proper \code{track.index} value), this argument is ignored.}

\item{track.margin}{only affect current track}

\item{cell.padding}{only affect current track}

\item{bg.col}{Background color for the plotting regions. It can be vector which has the same length of sectors.}

\item{bg.border}{Color for the border of the plotting regions. It can be vector which has the same length of sectors.}

\item{bg.lty}{Line style for the border of the plotting regions. It can be vector which has the same length of sectors.}

\item{bg.lwd}{Line width for the border of the plotting regions. It can be vector which has the same length of sectors.}

\item{panel.fun}{Panel function to add graphics in each cell, see "details" section and vignette for explanation.}

\item{factors}{The same as \code{sectors}. It will be removed in future versions. }
}
\value{
Object \linkS4class{ccTrack}
}
\description{
Object \linkS4class{ccTrack} will call the function \link[circlize:circos.trackPlotRegion]{circlize::circos.trackPlotRegion} while drawing.
}
\examples{
library(circlizePlus)
n = 1000
df = data.frame(sectors = sample(letters[1:8], n, replace = TRUE),
                x = rnorm(n), y = runif(n))
library(circlizePlus)
par1=ccPar("track.height" = 0.1)
cc=ccPlot(sectors = df$sectors, x = df$x) + par1
track1 = ccTrack(sectors = df$sectors, y = df$y,
                 panel.fun = function(x, y) {
                   circos.text(CELL_META$xcenter,
                               CELL_META$cell.ylim[2] + mm_y(5),
                               CELL_META$sector.index)
                   circos.axis(labels.cex = 0.6)
                 })
cc=cc+track1
cc
circos.clear()
}
