% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track-geom.R
\name{ccTrackLines}
\alias{ccTrackLines}
\title{Add lines on all sections of a single track.}
\usage{
ccTrackLines(
  sectors,
  x,
  y,
  col = par("col"),
  lwd = par("lwd"),
  lty = par("lty"),
  type = "l",
  straight = FALSE,
  area = FALSE,
  area.baseline = NULL,
  border = "black",
  baseline = "bottom",
  pt.col = par("col"),
  cex = par("cex"),
  pch = par("pch"),
  factors = sectors
)
}
\arguments{
\item{sectors}{A \code{\link{factor}} or a character vector which represents the categories of data.}

\item{x}{Data points on x-axis.}

\item{y}{Data points on y-axis.}

\item{col}{Line color.}

\item{lwd}{Line width.}

\item{lty}{Line style.}

\item{type}{Line type, similar as \code{type} argument in \code{\link[graphics]{lines}}, but only in \code{c("l", "o", "h", "s")}.}

\item{straight}{Whether draw straight lines between points.}

\item{area}{Whether to fill the area below the lines. If it is set to \code{TRUE}, \code{col} controls the filled color in the area and \code{border} controls the color of the line.}

\item{area.baseline}{Deprecated, use \code{baseline} instead.}

\item{border}{Color for border of the area.}

\item{baseline}{The base line to draw area, pass to \code{\link[circlize]{circos.lines}}.}

\item{pt.col}{If \code{type} is "o", points color.}

\item{cex}{If \code{type} is "o", points size.}

\item{pch}{If \code{type} is "o", points type.}

\item{factors}{The same as \code{sectors}. It will be removed in future versions. }
}
\value{
Object \linkS4class{ccTrackGeom}
}
\description{
Object \linkS4class{ccTrackGeom} will call the function \link[circlize:circos.trackLines]{circlize::circos.trackLines} while drawing.
}
\examples{
NULL
}
