% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selciuupi.R
\name{selciuupi}
\alias{selciuupi}
\title{Compute the scaled expected length of the CIUUPI}
\usage{
selciuupi(gam, bsvec, alpha, natural = 1, rho = NULL, a, c, x)
}
\arguments{
\item{gam}{A value of gamma or vector of gamma values at which
the scaled expected length function is evaluated}

\item{bsvec}{The vector (b(1),...,b(5),s(0),...,s(5)) that specifies the CIUUPI}

\item{alpha}{The minimum coverage probability is 1 - \code{alpha}}

\item{natural}{Equal to 1 (default) if the functions b and s are obtained by natural cubic
spline interpolation or 0 if obtained by clamped cubic spline interpolation}

\item{rho}{A known correlation}

\item{a}{A vector used to specify the parameter of interest}

\item{c}{A vector used to specify the parameter about which
we have uncertain prior information}

\item{x}{The n by p design matrix}
}
\value{
The value(s) of the scaled expected length at \code{gam}.
}
\description{
Evaluate the scaled expected length of the confidence interval that
utilizes uncertain prior information (CIUUPI) at \code{gam}.
}
\details{
Suppose that \deqn{y = X \beta + \epsilon} where \eqn{y} is a random \eqn{n}-vector of
responses, \eqn{X} is a known \eqn{n} by \eqn{p} matrix with linearly
independent columns, \eqn{\beta} is an unknown parameter \eqn{p}-vector and
\eqn{\epsilon} is the random error with components that are iid normally distributed
with zero mean and known variance.
The parameter of interest is \eqn{\theta = } \code{a}' \eqn{\beta}. The uncertain
prior information is that \eqn{\tau = } \code{c}' \eqn{\beta} -
\code{t} = 0, where \code{a}
and \code{c} are specified linearly independent vectors and \code{t} is a specified number.
 \code{rho} is the known
correlation between the least squares estimators of \eqn{\theta} and \eqn{\tau}.
The user must specify either \code{a}, \code{c} and \code{x} or
\code{rho}.  If \code{a}, \code{c} and \code{x} are specified then
\code{rho} is computed.

The CIUUPI is specified by the vector (b(1),...,b(5),s(0),...,s(5)), \code{alpha} and \code{natural}

The scaled expected length is defined as the expected length of the
CIUUPI divided
by the expected length of the standard confidence interval with the same minimum coverage probability.
}
\examples{
alpha <- 0.05

# Find the vector (b(1),b(2),...,b(5),s(0),s(1),...,s(5)) that specifies the
# CIUUPI: (this may take a few minutes to run)
\donttest{
bsvec <- bsciuupi(alpha, rho = 0.4)
}

# The result (to 7 decimal places) is
bsvec <- c(0.129443483, 0.218926703, 0.125880945, 0.024672734, -0.001427343,
           1.792489585, 1.893870240, 2.081786492, 2.080407355,  1.986667246,
           1.958594824)

# Graph the scaled expected length function
gam <- seq(0, 8, by = 0.1)
sel <- selciuupi(gam, bsvec, alpha, rho = 0.4)
plot(gam, sel, type = "l", lwd = 2, ylab = "", las = 1, xaxs = "i",
main = "Scaled Expected Length", col = "blue",
xlab = expression(paste("|", gamma, "|")))
abline(h = 1, lty = 2)

}
\seealso{
\code{\link{ciuupi}}, \code{\link{bsciuupi}}
}
