% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/civis_ml_workflows.R
\name{civis_ml_sparse_linear_regressor}
\alias{civis_ml_sparse_linear_regressor}
\title{CivisML Sparse Linear Regression}
\usage{
civis_ml_sparse_linear_regressor(x, dependent_variable,
  primary_key = NULL, excluded_columns = NULL, fit_intercept = TRUE,
  normalize = FALSE, fit_params = NULL,
  cross_validation_parameters = NULL, oos_scores_table = NULL,
  oos_scores_db = NULL, oos_scores_if_exists = c("fail", "append",
  "drop", "truncate"), model_name = NULL, cpu_requested = NULL,
  memory_requested = NULL, disk_requested = NULL,
  notifications = NULL, polling_interval = NULL, verbose = FALSE)
}
\arguments{
\item{x}{See the Data Sources section below.}

\item{dependent_variable}{The dependent variable of the training dataset.
For a multi-target problem, this should be a vector of column names of
dependent variables. Nulls in a single dependent variable will
automatically be dropped.}

\item{primary_key}{Optional, the unique ID (primary key) of the training
dataset. This will be used to index the out-of-sample scores. In
\code{predict.civis_ml}, the primary_key of the training task is used by
default \code{primary_key = NA}. Use \code{primary_key = NULL} to
explicitly indicate the data have no primary_key.}

\item{excluded_columns}{Optional, a vector of columns which will be
considered ineligible to be independent variables.}

\item{fit_intercept}{Should an intercept term be included in the model. If
\code{FALSE}, no intercept will be included, in this case the data are
expected to already be centered.}

\item{normalize}{If \code{TRUE}, the regressors will be normalized before
fitting the model. \code{normalize} is ignored when
\code{fit_intercept = FALSE}.}

\item{fit_params}{Optional, a mapping from parameter names in the model's
\code{fit} method to the column names which hold the data, e.g.
\code{list(sample_weight = 'survey_weight_column')}.}

\item{cross_validation_parameters}{Optional, parameter grid for learner
parameters, e.g. \code{list(n_estimators = c(100, 200, 500),
learning_rate = c(0.01, 0.1), max_depth = c(2, 3))}
or \code{"hyperband"} for supported models.}

\item{oos_scores_table}{Optional, if provided, store out-of-sample
predictions on training set data to this Redshift "schema.tablename".}

\item{oos_scores_db}{Optional, the name of the database where the
\code{oos_scores_table} will be created. If not provided, this will default
to \code{database_name}.}

\item{oos_scores_if_exists}{Optional, action to take if
\code{oos_scores_table} already exists. One of \code{"fail"}, \code{"append"}, \code{"drop"}, or \code{"truncate"}.
The default is \code{"fail"}.}

\item{model_name}{Optional, the prefix of the Platform modeling jobs.
It will have \code{" Train"} or \code{" Predict"} added to become the Script title.}

\item{cpu_requested}{Optional, the number of CPU shares requested in the
Civis Platform for training jobs or prediction child jobs.
1024 shares = 1 CPU.}

\item{memory_requested}{Optional, the memory requested from Civis Platform
for training jobs or prediction child jobs, in MiB.}

\item{disk_requested}{Optional, the disk space requested on Civis Platform
for training jobs or prediction child jobs, in GB.}

\item{notifications}{Optional, model status notifications. See
\code{\link{scripts_post_custom}} for further documentation about email
and URL notification.}

\item{polling_interval}{Check for job completion every this number of seconds.}

\item{verbose}{Optional, If \code{TRUE}, supply debug outputs in Platform
logs and make prediction child jobs visible.}
}
\value{
A \code{civis_ml} object, a list containing the following elements:
\item{job}{job metadata from \code{\link{scripts_get_custom}}.}
\item{run}{run metadata from \code{\link{scripts_get_custom_runs}}.}
\item{outputs}{CivisML metadata from \code{\link{scripts_list_custom_runs_outputs}} containing the locations of
 files produced by CivisML e.g. files, projects, metrics, model_info, logs, predictions, and estimators.}
\item{metrics}{Parsed CivisML output from \code{metrics.json} containing metadata from validation.
 A list containing the following elements:
  \itemize{
  \item run list, metadata about the run.
  \item data list, metadata about the training data.
  \item model list, the fitted scikit-learn model with CV results.
  \item metrics list, validation metrics (accuracy, confusion, ROC, AUC, etc).
  \item warnings list.
  \item data_platform list, training data location.
}}
\item{model_info}{Parsed CivisML output from \code{model_info.json} containing metadata from training.
 A list containing the following elements:
  \itemize{
  \item run list, metadata about the run.
  \item data list, metadata about the training data.
  \item model list, the fitted scikit-learn model.
  \item metrics empty list.
  \item warnings list.
  \item data_platform list, training data location.
  }}
}
\description{
CivisML Sparse Linear Regression
}
\section{Data Sources}{


For building models with \code{civis_ml}, the training data can reside in
four different places, a file in the Civis Platform, a CSV or feather-format file
on the local disk, a \code{data.frame} resident in local the R environment, and finally,
a table in the Civis Platform. Use the following helpers to specify the
data source when calling \code{civis_ml}:

\describe{
  \item{\code{data.frame}}{\code{civis_ml(x = df, ...)}}
  \item{local csv file}{\code{civis_ml(x = "path/to/data.csv", ...)}}
  \item{file in Civis Platform}{\code{civis_ml(x = civis_file(1234))}}
  \item{table in Civis Platform}{\code{civis_ml(x = civis_table(table_name = "schema.table", database_name = "database"))}}
}
}

\examples{
\dontrun{
 data(ChickWeight)
 m <- civis_ml_sparse_linear_regressor(ChickWeight, dependent_variable = "weight")
 yhat <- fetch_oos_scores(m)

# make a prediction job, storing in a redshift table
pred_info <- predict(m, newdata = civis_table("schema.table", "my_database"),
   output_table = "schema.scores_table")

}
}
