% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/civis_ml_workflows.R
\name{civis_ml_sparse_logistic}
\alias{civis_ml_sparse_logistic}
\title{CivisML Sparse Logistic}
\usage{
civis_ml_sparse_logistic(x, dependent_variable, primary_key = NULL,
  excluded_columns = NULL, penalty = c("l2", "l1"), dual = FALSE,
  tol = 1e-08, C = 499999950, fit_intercept = TRUE,
  intercept_scaling = 1, class_weight = NULL, random_state = 42,
  solver = c("liblinear", "newton-cg", "lbfgs", "sag"), max_iter = 100,
  multi_class = c("ovr", "multinomial"), fit_params = NULL,
  cross_validation_parameters = NULL, calibration = NULL,
  oos_scores_table = NULL, oos_scores_db = NULL,
  oos_scores_if_exists = c("fail", "append", "drop", "truncate"),
  model_name = NULL, cpu_requested = NULL, memory_requested = NULL,
  disk_requested = NULL, notifications = NULL,
  polling_interval = NULL, verbose = FALSE)
}
\arguments{
\item{x}{See the Data Sources section below.}

\item{dependent_variable}{The dependent variable of the training dataset.
For a multi-target problem, this should be a vector of column names of
dependent variables. Nulls in a single dependent variable will
automatically be dropped.}

\item{primary_key}{Optional, the unique ID (primary key) of the training
dataset. This will be used to index the out-of-sample scores. In
\code{predict.civis_ml}, the primary_key of the training task is used by
default \code{primary_key = NA}. Use \code{primary_key = NULL} to
explicitly indicate the data have no primary_key.}

\item{excluded_columns}{Optional, a vector of columns which will be
considered ineligible to be independent variables.}

\item{penalty}{Used to specify the norm used in the penalization. The
\code{newton-cg}, \code{sag}, and \code{lbfgs} solvers support only l2
penalties.}

\item{dual}{Dual or primal formulation. Dual formulation is only implemented
for \code{l2} penalty with the \code{liblinear} solver. \code{dual = FALSE}
should be preferred when n_samples > n_features.}

\item{tol}{Tolerance for stopping criteria.}

\item{C}{Inverse of regularization strength, must be a positive float.
Smaller values specify stronger regularization.}

\item{fit_intercept}{Should a constant or intercept term be included in the
model.}

\item{intercept_scaling}{Useful only when the \code{solver = "liblinear"}
and \code{fit_intercept = TRUE}. In this case, a constant term with the
value \code{intercept_scaling} is added to the design matrix.}

\item{class_weight}{A \code{list} with \code{class_label = value} pairs, or
  \code{balanced}. When \code{class_weight = "balanced"}, the class weights
  will be inversely proportional to the class frequencies in the input data
  as:
    \deqn{ \frac{n_samples}{n_classes * table(y)} }

  Note, the class weights are multiplied with \code{sample_weight}
  (passed via \code{fit_params}) if \code{sample_weight} is specified.}

\item{random_state}{The seed of the random number generator to use when
shuffling the data. Used only in \code{solver = "sag"} and
\code{solver = "liblinear"}.}

\item{solver}{Algorithm to use in the optimization problem. For small data
  \code{liblinear} is a good choice. \code{sag} is faster for larger
  problems. For multiclass problems, only \code{newton-cg}, \code{sag}, and
  \code{lbfgs} handle multinomial loss. \code{liblinear} is limited to
  one-versus-rest schemes. \code{newton-cg}, \code{lbfgs}, and \code{sag}
  only handle the \code{l2} penalty.

  Note that \code{sag} fast convergence is only guaranteed on features with
  approximately the same scale.}

\item{max_iter}{The maximum number of iterations taken for the solvers to
converge. Useful for the \code{newton-cg}, \code{sag}, and \code{lbfgs}
solvers.}

\item{multi_class}{The scheme for multi-class problems. When \code{ovr}, then
a binary problem is fit for each label. When \code{multinomial}, a single
model is fit minimizing the multinomial loss. Note, \code{multinomial} only
works with the \code{newton-cg}, \code{sag}, and \code{lbfgs} solvers.}

\item{fit_params}{Optional, a mapping from parameter names in the model's
\code{fit} method to the column names which hold the data, e.g.
\code{list(sample_weight = 'survey_weight_column')}.}

\item{cross_validation_parameters}{Optional, parameter grid for learner
parameters, e.g. \code{list(n_estimators = c(100, 200, 500),
learning_rate = c(0.01, 0.1), max_depth = c(2, 3))}
or \code{"hyperband"} for supported models.}

\item{calibration}{Optional, if not \code{NULL}, calibrate output
probabilities with the selected method, \code{sigmoid}, or \code{isotonic}.
Valid only with classification models.}

\item{oos_scores_table}{Optional, if provided, store out-of-sample
predictions on training set data to this Redshift "schema.tablename".}

\item{oos_scores_db}{Optional, the name of the database where the
\code{oos_scores_table} will be created. If not provided, this will default
to \code{database_name}.}

\item{oos_scores_if_exists}{Optional, action to take if
\code{oos_scores_table} already exists. One of \code{"fail"}, \code{"append"}, \code{"drop"}, or \code{"truncate"}.
The default is \code{"fail"}.}

\item{model_name}{Optional, the prefix of the Platform modeling jobs.
It will have \code{" Train"} or \code{" Predict"} added to become the Script title.}

\item{cpu_requested}{Optional, the number of CPU shares requested in the
Civis Platform for training jobs or prediction child jobs.
1024 shares = 1 CPU.}

\item{memory_requested}{Optional, the memory requested from Civis Platform
for training jobs or prediction child jobs, in MiB.}

\item{disk_requested}{Optional, the disk space requested on Civis Platform
for training jobs or prediction child jobs, in GB.}

\item{notifications}{Optional, model status notifications. See
\code{\link{scripts_post_custom}} for further documentation about email
and URL notification.}

\item{polling_interval}{Check for job completion every this number of seconds.}

\item{verbose}{Optional, If \code{TRUE}, supply debug outputs in Platform
logs and make prediction child jobs visible.}
}
\value{
A \code{civis_ml} object, a list containing the following elements:
\item{job}{job metadata from \code{\link{scripts_get_custom}}.}
\item{run}{run metadata from \code{\link{scripts_get_custom_runs}}.}
\item{outputs}{CivisML metadata from \code{\link{scripts_list_custom_runs_outputs}} containing the locations of
 files produced by CivisML e.g. files, projects, metrics, model_info, logs, predictions, and estimators.}
\item{metrics}{Parsed CivisML output from \code{metrics.json} containing metadata from validation.
 A list containing the following elements:
  \itemize{
  \item run list, metadata about the run.
  \item data list, metadata about the training data.
  \item model list, the fitted scikit-learn model with CV results.
  \item metrics list, validation metrics (accuracy, confusion, ROC, AUC, etc).
  \item warnings list.
  \item data_platform list, training data location.
}}
\item{model_info}{Parsed CivisML output from \code{model_info.json} containing metadata from training.
 A list containing the following elements:
  \itemize{
  \item run list, metadata about the run.
  \item data list, metadata about the training data.
  \item model list, the fitted scikit-learn model.
  \item metrics empty list.
  \item warnings list.
  \item data_platform list, training data location.
  }}
}
\description{
CivisML Sparse Logistic
}
\section{Data Sources}{


For building models with \code{civis_ml}, the training data can reside in
four different places, a file in the Civis Platform, a CSV or feather-format file
on the local disk, a \code{data.frame} resident in local the R environment, and finally,
a table in the Civis Platform. Use the following helpers to specify the
data source when calling \code{civis_ml}:

\describe{
  \item{\code{data.frame}}{\code{civis_ml(x = df, ...)}}
  \item{local csv file}{\code{civis_ml(x = "path/to/data.csv", ...)}}
  \item{file in Civis Platform}{\code{civis_ml(x = civis_file(1234))}}
  \item{table in Civis Platform}{\code{civis_ml(x = civis_table(table_name = "schema.table", database_name = "database"))}}
}
}

\examples{
\dontrun{

df <- iris
names(df) <- gsub("\\\\.", "_", names(df))

m <- civis_ml_sparse_logistic(df, "Species")
yhat <- fetch_oos_scores(m)

# Grid Search
cv_params <- list(C = c(.01, 1, 10, 100, 1000))

m <- civis_ml_sparse_logistic(df, "Species",
  cross_validation_parameters = cv_params)

# make a prediction job, storing in a redshift table
pred_info <- predict(m, newdata = civis_table("schema.table", "my_database"),
   output_table = "schema.scores_table")

}
}
