% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{credentials_get}
\alias{credentials_get}
\title{Get a credential}
\usage{
credentials_get(id)
}
\arguments{
\item{id}{integer required. The ID of the credential.}
}
\value{
A list containing the following elements:
\item{id}{integer, The ID of the credential.}
\item{name}{string, The name identifying the credential}
\item{type}{string, The credential's type.}
\item{username}{string, The username for the credential.}
\item{description}{string, A long description of the credential.}
\item{owner}{string, The username of the user who this credential belongs to. Using user.username is preferred.}
\item{user}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{remoteHostId}{integer, The ID of the remote host associated with this credential.}
\item{remoteHostName}{string, The name of the remote host associated with this credential.}
\item{state}{string, The U.S. state for the credential. Only for VAN credentials.}
\item{createdAt}{string, The creation time for this credential.}
\item{updatedAt}{string, The last modification time for this credential.}
\item{default}{boolean, Whether or not the credential is a default. Only for Database credentials.}
}
\description{
Get a credential
}
