% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{scripts_patch_javascript_git}
\alias{scripts_patch_javascript_git}
\title{Update an attached git file}
\usage{
scripts_patch_javascript_git(
  id,
  git_ref = NULL,
  git_branch = NULL,
  git_path = NULL,
  git_repo_url = NULL,
  git_ref_type = NULL,
  pull_from_git = NULL
)
}
\arguments{
\item{id}{integer required. The ID of the file.}

\item{git_ref}{string optional. A git reference specifying an unambiguous version of the file. Can be a branch name, or the full or shortened SHA of a commit.}

\item{git_branch}{string optional. The git branch that the file is on.}

\item{git_path}{string optional. The path of the file in the repository.}

\item{git_repo_url}{string optional. The URL of the git repository.}

\item{git_ref_type}{string optional. Specifies if the file is versioned by branch or tag.}

\item{pull_from_git}{boolean optional. Automatically pull latest commit from git. Only works for scripts.}
}
\value{
A list containing the following elements:
\item{gitRef}{string, A git reference specifying an unambiguous version of the file. Can be a branch name, tag or the full or shortened SHA of a commit.}
\item{gitBranch}{string, The git branch that the file is on.}
\item{gitPath}{string, The path of the file in the repository.}
\item{gitRepo}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID for this git repository.
\item repoUrl string, The URL for this git repository.
\item createdAt string, 
\item updatedAt string, 
}}
\item{gitRefType}{string, Specifies if the file is versioned by branch or tag.}
\item{pullFromGit}{boolean, Automatically pull latest commit from git. Only works for scripts and workflows (assuming you have the feature enabled)}
}
\description{
Update an attached git file
}
