% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/package_show.R
\name{package_show}
\alias{package_show}
\title{Show a package.}
\usage{
package_show(id, use_default_schema = FALSE, url = get_default_url(),
  as = "list", ...)
}
\arguments{
\item{id}{(character) Package identifier.}

\item{use_default_schema}{(logical) Use default package schema instead of a
custom schema defined with an IDatasetForm plugin. Default: FALSE}

\item{url}{Base url to use. Default: \url{http://data.techno-science.ca}. See
also \code{\link{ckanr_setup}} and \code{\link{get_default_url}}.}

\item{as}{(character) One of list (default), table, or json. Parsing with table option
uses \code{jsonlite::fromJSON(..., simplifyDataFrame = TRUE)}, which attempts to parse
data to data.frame's when possible, so the result can vary from a vector, list or
data.frame. (required)}

\item{...}{Curl args passed on to \code{\link[httr]{POST}} (optional)}
}
\description{
Show a package.
}
\details{
By default the help and success slots are dropped, and only the
  result slot is returned. You can request raw json with \code{as = 'json'}
  then parse yourself to get the help slot.
}
\examples{
\dontrun{
# Setup
ckanr_setup(url = "http://demo.ckan.org/", key = getOption("ckan_demo_key"))

# create a package
(res <- package_create("purposeful55"))

# show package
## From the output of package_create
package_show(res)
## Or, from the ID
package_show(res$id)

# get data back in different formats
package_show(res$id, as = 'json')
package_show(res$id, as = 'table')

# use default schema or not
package_show(res$id, TRUE)
}
}

