% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/package_update.R
\name{package_update}
\alias{package_update}
\title{Update a package}
\usage{
package_update(x, id, url = get_default_url(), key = get_default_key(),
  as = "list", ...)
}
\arguments{
\item{x}{(list) A list with key-value pairs}

\item{id}{(character) Package identifier}

\item{url}{Base url to use. Default: \url{http://data.techno-science.ca}. See
also \code{\link{ckanr_setup}} and \code{\link{get_default_url}}.}

\item{key}{A privileged CKAN API key, Default: your key set with \code{\link{ckanr_setup}}}

\item{as}{(character) One of list (default), table, or json. Parsing with table option
uses \code{jsonlite::fromJSON(..., simplifyDataFrame = TRUE)}, which attempts to parse
data to data.frame's when possible, so the result can vary from a vector, list or
data.frame. (required)}

\item{...}{Curl args passed on to \code{\link[httr]{POST}} (optional)}
}
\description{
Update a package
}
\examples{
\dontrun{
# Setup
ckanr_setup(url = "http://demo.ckan.org/", key = getOption("ckan_demo_key"))

# First, show a package to see the fields
res <- package_show('585d7ea2-ded0-4fed-9b08-61f7e83a3cb2')
res

## update just chosen things
# Make some changes
x <- list(maintainer_email = "heythere2@things.com")

# Then update the packge
package_update(x, '585d7ea2-ded0-4fed-9b08-61f7e83a3cb2')
}
}

