% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package_activity_list.R
\name{package_activity_list}
\alias{package_activity_list}
\title{Return a list of the package's activity}
\usage{
package_activity_list(
  id,
  offset = 0,
  limit = 31,
  url = get_default_url(),
  key = get_default_key(),
  as = "list",
  ...
)
}
\arguments{
\item{id}{(character) Package identifier.}

\item{offset}{(numeric) Where to start getting activity items from
(optional, default: 0)}

\item{limit}{(numeric) The maximum number of activities to return
(optional, default: 31)}

\item{url}{Base url to use. Default: https://data.ontario.ca/ See
also \code{\link{ckanr_setup}} and \code{\link{get_default_url}}.}

\item{key}{A privileged CKAN API key, Default: your key set with
\code{\link{ckanr_setup}}}

\item{as}{(character) One of list (default), table, or json. Parsing with
table option uses \code{jsonlite::fromJSON(..., simplifyDataFrame = TRUE)},
which attempts to parse data to data.frame's when possible, so the result
can vary from a vector, list or data.frame. (required)}

\item{...}{Curl args passed on to \code{\link[crul]{verb-POST}} (optional)}
}
\description{
Return a list of the package's activity
}
\examples{
\dontrun{
# Setup
ckanr_setup(url = "https://demo.ckan.org/", key = getOption("ckan_demo_key"))

# create a package
(res <- package_create("owls64"))

# list package activity
package_activity_list(res$id)

# make a change
x <- list(maintainer = "Jane Forest")
package_update(x, res)

# list activity again
package_activity_list(res)

# output different data formats
package_activity_list(res$id, as = "table")
package_activity_list(res$id, as = "json")
}
}
