% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{add_to_report}
\alias{add_to_report}
\title{Add an element to the report object}
\usage{
add_to_report(x, key, value = NULL)
}
\arguments{
\item{x}{A data frame  or linelist}

\item{key}{The name of the cleaning operation}

\item{value}{The object to add to the report object}
}
\value{
The input report object with an additional element
}
\description{
Add an element to the report object
}
\examples{
# scan through the data
scan_res <- scan_data(data = readRDS(system.file("extdata", "test_df.RDS",
                                                 package = "cleanepi")))

# Perform data cleaning
cleaned_data <- clean_data(
  data   = readRDS(system.file("extdata", "test_df.RDS",
                               package = "cleanepi")),
  params = list(
    to_numeric = list(target_columns = "sex", lang = "en"),
    dictionary = NULL
  )
)

# add the data scanning result to the report
cleaned_data <- add_to_report(x     = cleaned_data,
                              key   = "scanning_result",
                              value = scan_res)

}
