% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date_standardization_helpers.R
\name{date_convert_and_update}
\alias{date_convert_and_update}
\title{Convert and update the date values}
\usage{
date_convert_and_update(
  data,
  timeframe,
  new_dates,
  cols,
  error_tolerance = 0.5
)
}
\arguments{
\item{data}{A data frame or linelist}

\item{timeframe}{A vector of 2 values of type date. If provided, date values
that do not fall within this timeframe will be set to \code{NA}.}

\item{new_dates}{A vector of the converted date values}

\item{cols}{The names of the date column been converted}

\item{error_tolerance}{A number between 0 and 1 indicating the proportion of
entries which cannot be identified as dates to be tolerated; if this
proportion is exceeded, the original vector is returned, and a message is
issued; defaults to 0.4 (40 percent).}
}
\value{
A list of 2 data frames: the updated input data (if some columns
were converted to Date) and a data frame of date values that are not
within the specified timeframe.
}
\description{
Convert and update the date values
}
\keyword{internal}
