% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_missing_values.R
\name{replace_missing_values}
\alias{replace_missing_values}
\title{Replace missing values with \code{NA}}
\usage{
replace_missing_values(
  data,
  target_columns = NULL,
  na_strings = cleanepi::common_na_strings
)
}
\arguments{
\item{data}{A data frame or linelist}

\item{target_columns}{A vector of column names. If provided, the substitution
of missing values will only be executed in those specified columns. When
the input data is a \code{linelist} object, this parameter can be set to
\code{linelist_tags} if you wish to replace missing values with NA on tagged
columns only.}

\item{na_strings}{This is a vector of strings that represents the missing
values in the columns of interest. By default, it utilizes
\code{cleanepi::common_na_strings}. However, if the missing values string in
the columns of interest is not included in this predefined vector,
it can be used as the value for this argument.}
}
\value{
The input data where missing values are replaced by \code{NA}.
}
\description{
Replace missing values with \code{NA}
}
\examples{
cleaned_data <- replace_missing_values(
  data           = readRDS(system.file("extdata", "test_df.RDS",
                                       package = "cleanepi")),
  target_columns = "sex",
  na_strings     = "-99"
)

}
