% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bullets.R
\name{cli_bullets}
\alias{cli_bullets}
\title{List of items}
\usage{
cli_bullets(text, id = NULL, class = NULL, .envir = parent.frame())
}
\arguments{
\item{text}{Character vector of items. See details below on how names
are interpreted.}

\item{id}{Optional id of the \code{div.bullets} element, can be used in themes.}

\item{class}{Optional additional class(es) for the \code{div.bullets} element.}

\item{.envir}{Environment to evaluate the glue expressions in.}
}
\description{
It is often useful to print out a list of items, tasks a function or
package performs, or a list of notes.
}
\details{
Items may be formatted differently, e.g. they can have a prefix symbol.
Formatting is specified by the names of \code{text}, and can be themed.
cli creates a \code{div} element of class \code{bullets} for the whole bullet list.
Each item is another \code{div} element of class \verb{bullet-<name>}, where
\verb{<name>} is the name of the entry in \code{text}. Entries in \code{text} without
a name create a \code{div} element of class \code{buller-empty}, and if the
name is a single space character, the class is \code{bullet-space}.

The built-in theme defines the following item types:
\itemize{
\item No name: Item without a prefix.
\item \verb{ }: Indented item.
\item \code{*}: Item with a bullet.
\item \code{>}: Item with an arrow or pointer.
\item \code{v}: Item with a green "tick" symbol, like \code{\link[=cli_alert_success]{cli_alert_success()}}.
\item \code{x}: Item with a ref cross, like \code{\link[=cli_alert_danger]{cli_alert_danger()}}.
\item \code{!}: Item with a yellow exclamation mark, like \code{\link[=cli_alert_warning]{cli_alert_warning()}}.
\item \code{i}: Info item, like \code{\link[=cli_alert_info]{cli_alert_info()}}.
}

You can define new item type by simply defining theming for the
corresponding \verb{bullet-<name>} classes.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{cli_bullets(c(
        "noindent",
  " " = "indent",
  "*" = "bullet",
  ">" = "arrow",
  "v" = "success",
  "x" = "danger",
  "!" = "warning",
  "i" = "info"
))
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> noindent                                                                        
#>   indent                                                                        
#> <span style="color: #2AA198;">•</span> bullet                                                                        
#> → arrow                                                                         
#> <span style="color: #859900;">✔</span> success                                                                       
#> <span style="color: #DC322F;">✖</span> danger                                                                        
#> <span style="color: #B58900;">!</span> warning                                                                       
#> <span style="color: #2AA198;">ℹ</span> info                                                                          
</pre></div>
}}
}
