% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cliapp-docs.R
\name{links}
\alias{links}
\title{cli hyperlinks}
\description{
Certain cli styles create clickable links, if your IDE or terminal
supports them.
}
\section{Note: hyperlinks are currently experimental}{
The details of the styles that create hyperlinks will prrobably change
in the near future, based on user feedback.
}

\section{About the links in this manual page}{
The hyperlinks that are included in this manual are demonstrative
only, except for the \verb{https:} links. They look like a hyperlink, and
you can click on them, but they do nothing. I.e. a \code{.run} link will
not run the linked expression if you click on it.
}

\section{Hyperlink Support}{
As of today, the latest release of RStudio (version v2022.07.0+548)
supports all hyperlink types discussed here. Certain terminals, e.g.
iTerm on macOS, Linux terminals based on VTE (GNOME terminal) support
\code{.href}, \code{.email} and \code{.file} links.

You can use \code{\link[=ansi_has_hyperlink_support]{ansi_has_hyperlink_support()}} to check if your terminal or
IDE has hyperlink support in general, and \code{\link[=ansi_hyperlink_types]{ansi_hyperlink_types()}} to
check if various types of hyperlinks are supported.

If your hyperlink support is not detected properly in your IDE or
terminal, please open a cli issue at
\url{https://github.com/r-lib/cli/issues}.
}

\section{Link text}{
Before we delve into the various types of hyperlinks, a general comment
about link texts. Some link styles support a custom link text:
\itemize{
\item \code{.href}
\item \code{.help}
\item \code{.topic}
\item \code{.vignette}
\item \code{.run}
}

Others, i.e. \code{.email}, \code{.file}, \code{.fun} and \code{.url} do not support custom
link text.

The generic syntax for link text is the same as for Markdown hyperlinks:

\if{html}{\out{<div class="sourceCode">}}\preformatted{\{.style [link text](url)\}
}\if{html}{\out{</div>}}
\subsection{Vectorization}{

Note that it is not possible to add link text to a vector of URLs. E.g.
this will create a list of three URLs, all clickable:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{urls <- paste0("https://httpbin.org/status/", c(200, 403, 404))
cli::cli_text("Some httpbin URLs: \{.url \{urls\}\}.")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> Some httpbin URLs: <span style="font-style: italic;color: #268BD2;">&lt;</span><span style="font-style: italic;color: #268BD2;"><a href="https://httpbin.org/status/200">https://httpbin.org/status/200</a></span><span style="font-style: italic;color: #268BD2;">&gt;</span>,                            
#> <span style="font-style: italic;color: #268BD2;">&lt;</span><span style="font-style: italic;color: #268BD2;"><a href="https://httpbin.org/status/403">https://httpbin.org/status/403</a></span><span style="font-style: italic;color: #268BD2;">&gt;</span>, and                                           
#> <span style="font-style: italic;color: #268BD2;">&lt;</span><span style="font-style: italic;color: #268BD2;"><a href="https://httpbin.org/status/404">https://httpbin.org/status/404</a></span><span style="font-style: italic;color: #268BD2;">&gt;</span>.                                               
</pre></div>
But it is not possible to use a different link text for them.
}}

}

\subsection{What if hyperlinks are not available?}{

If ANSI hyperlinks are not available, then the link text for of these
styles outputs both the link text and the URL in a (hopefully) helpful
way. See examples below.
}
}

\section{URLs}{
There are two cli styles to link to generic URLs. \code{.url} does not
allow custom link text, but \verb{\\href} does.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{cli_text(
  "See the cli homepage at \{.url https://cli.r-lib.org\} for details."
)
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> See the cli homepage at <span style="font-style: italic;color: #268BD2;">&lt;</span><span style="font-style: italic;color: #268BD2;"><a href="https://cli.r-lib.org">https://cli.r-lib.org</a></span><span style="font-style: italic;color: #268BD2;">&gt;</span> for details.                    
</pre></div>
}}


\if{html}{\out{<div class="sourceCode r">}}\preformatted{cli_text(
  "See the \{.href [cli homepage](https://cli.r-lib.org)\} for details."
)
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> See the <a href="https://cli.r-lib.org">cli homepage</a> for details.                                               
</pre></div>
}}

\subsection{Without hyperlink support}{

This is how these links look without hyperlink support:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{local(\{
  withr::local_options(cli.hyperlink = FALSE)
  cli_text(
    "See the cli homepage at \{.url https://cli.r-lib.org\} for details."
  )
  cli_text(
    "See the \{.href [cli homepage](https://cli.r-lib.org)\} for details."
  )
\})
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> See the cli homepage at <span style="font-style: italic;color: #268BD2;">&lt;https://cli.r-lib.org&gt;</span> for details.                    
#> See the cli homepage (<span style="font-style: italic;color: #268BD2;">&lt;https://cli.r-lib.org&gt;</span>) for details.                     
</pre></div>
}}

}

\subsection{URL encoding}{

Note that cli does not encode the url, so you might need to call
\code{utils::URLencode()} on it, especially, if it is substituted in
via \code{{}}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{weirdurl <- utils::URLencode("https://example.com/has some spaces")
cli_text("See more at \{.url \{weirdurl\}\}.")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> See more at <span style="font-style: italic;color: #268BD2;">&lt;</span><span style="font-style: italic;color: #268BD2;"><a href="https://example.com/has&#37;20some&#37;20spaces">https://example.com/has&#37;20some&#37;20spaces</a></span><span style="font-style: italic;color: #268BD2;">&gt;</span>.                          
</pre></div>
}}

}
}

\section{Files}{
The \code{.file} style now automatically creates a \verb{file:} hyperlink.
Because \verb{file:} hyperlinks must contain an absolute path, cli tries to
convert relative paths, and paths starting with \code{~} to aboslute path.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{cli_text("... edit your \{.file ~/.Rprofile\} file.\}")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> ... edit your <span style="color: #268BD2;"><a href="file:///Users/gaborcsardi/.Rprofile">~/.Rprofile</a></span> file.\}                                                
</pre></div>
}}

\subsection{Link text}{

\code{.file} cannot use a custom link text. If you custom link text, then
you can use \code{.href} with a \verb{file:} URL.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{prof <- path.expand("~/.Rprofile")
cli_text("... edit your \{.href [R profile](file://\{prof\})\}.")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> ... edit your <a href="file:///Users/gaborcsardi/.Rprofile">R profile</a>.                                                        
</pre></div>
}}

}

\subsection{Line and column numbers}{

You may add a line number to a file name, separated by \code{:}. Handlers
typically place the cursor at that line after opening the file.
You may also add a column number, after the line number, separated by
another \code{:}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{cli_text("... see line 5 in \{.file ~/.Rprofile:5\}.")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> ... see line 5 in <span style="color: #268BD2;"><a href="file:///Users/gaborcsardi/.Rprofile">~/.Rprofile:5</a></span>.                                                
</pre></div>
}}

}

\subsection{Default handler}{

In RStudio \verb{file:} URLs open within RStudio. If you click on a file
link outside of RStudio, typically the operating system is consulted
for the application to open it.
}

\subsection{Without hyperlink support}{

One issue with using \code{.href} file files is that it does not look great
if hyperlinks are not available. This will be improved in the future:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{local(\{
  withr::local_options(cli.hyperlink = FALSE)
  prof <- path.expand("~/.Rprofile")
  cli_text("... edit your \{.href [R profile](file://\{prof\})\}.")
\})
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> ... edit your R profile (<span style="font-style: italic;color: #268BD2;">&lt;file:///Users/gaborcsardi/.Rprofile&gt;</span>).                
</pre></div>
}}

}
}

\section{Links to the manual}{
\code{.fun} automatically creates links to the manual page of the function,
provided the function name is in the \code{packagename::functionname} form:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{cli::cli_text("... see \{.fun stats::lm\} to learn more.")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> ... see `<a href="x-r-help:stats::lm">stats::lm</a>()` to learn more.                                            
</pre></div>
}}

\subsection{Link text}{

For a custom link text, use \code{.help} instead of \code{.fun}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{cli::cli_text("... see \{.help [\{.fun lm\}](stats::lm)\} to learn more.")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> ... see <a href="x-r-help:stats::lm">`lm()`</a> to learn more.                                                   
</pre></div>
}}

}

\subsection{Without hyperlink support}{

The same message without hyperlink support looks like this:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{local(\{
  withr::local_options(cli.hyperlink = FALSE)
  cli::cli_text("... see \{.help [\{.fun lm\}](stats::lm)\} to learn more.")
\})
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> ... see `lm()` (`?stats::lm()`) to learn more.                                  
</pre></div>
}}

}

\subsection{Topics}{

To link to a help topic that is not a function, use \code{.topic}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{cli::cli_text("... the tibble options at \{.topic tibble::tibble_options\}.")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> ... the tibble options at <a href="x-r-help:tibble::tibble_options">tibble::tibble_options</a>.                               
</pre></div>
}}


\code{.topic} support link text.
}

\subsection{Vignettes}{

To link to a vignette, use \code{.vignette}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{cli::cli_text("... see the \{.vignette tibble::types\} vignette.")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> ... see the <a href="x-r-vignette:tibble::types">tibble::types</a> vignette.                                             
</pre></div>
}}

}
}

\section{Click to run code}{
RStudio also supports a special link type that runs R code in the
current R session upon clicking.

You can create these links with \code{.run}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{cli::cli_text("Run \{.run testthat::snapshot_review()\} to review")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> Run <a href="x-r-run:testthat::snapshot_review()">testthat::snapshot_review()</a> to review                                       
</pre></div>
}}

\subsection{Link text}{

Sometimes you want to show a slightly different expression in the link,
than the one that is evaluated. E.g. the evaluated expression probably
needs to qualify packages with \code{::}, but you might not want to show this:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{cli::cli_text(
  "Run \{.run [snapshot_review()](testthat::snapshot_review())\} to review"
)
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> Run <a href="x-r-run:testthat::snapshot_review()">snapshot_review()</a> to review                                                 
</pre></div>
}}

}

\subsection{Security considerations}{

To make \code{.run} hyperlinks more secure, RStudio will not run code
\itemize{
\item that is not in the \code{pkg::fun(args)} form,
\item if \code{args} contains \code{(}, \verb{)} or \verb{;},
\item if it calls a core package (base, stats, etc.),
\item if it calls a package that is not loaded, and it is not one of
testthat, devtools, usethis, rlang, pkgload, or pkgdown which are explicitly allowed.
}

When RStudio does not run a \code{.run} hyperlink, then it shows the code
and the user can copy and paste it to the console, if they consider
it safe to run.

Note that depending on your version of RStudio, the behavior can change.
}
}

