% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ansiex.R
\name{ansi_grep}
\alias{ansi_grep}
\alias{ansi_grepl}
\title{Like \code{\link[base:grep]{base::grep()}} and \code{\link[base:grep]{base::grepl()}}, but for ANSI strings}
\usage{
ansi_grep(pattern, x, ignore.case = FALSE, perl = FALSE, value = FALSE, ...)

ansi_grepl(pattern, x, ...)
}
\arguments{
\item{pattern}{Character scalar, regular expression or fixed string
(if \code{fixed = TRUE}), the pattern to search for. Other objects will be
coerced using \code{\link[=as.character]{as.character()}}.}

\item{x}{Character vector to search in. Other objects will be coerced
using \code{\link[=as.character]{as.character()}}.}

\item{ignore.case, perl, value}{Passed to \code{\link[base:grep]{base::grep()}}.}

\item{...}{Extra arguments are passed to \code{\link[base:grep]{base::grep()}} or \code{\link[base:grep]{base::grepl()}}.}
}
\value{
The same as \code{\link[base:grep]{base::grep()}} and \code{\link[base:grep]{base::grepl()}}, respectively.
}
\description{
First ANSI sequences will be stripped with \code{\link[=ansi_strip]{ansi_strip()}}, both
}
\details{
Note that these functions work on code points (or bytes if
\code{useBytes = TRUE}), and not graphemes.

Unlike \code{\link[base:grep]{base::grep()}} and \code{\link[base:grep]{base::grepl()}} these functions do not special
case factors.

Both \code{pattern} and \code{x} are converted to UTF-8.
}
\examples{
red_needle <- col_red("needle")
haystack <- c("foo", "needle", "foo")
green_haystack <- col_green(haystack)
ansi_grepl(red_needle, haystack)
ansi_grepl(red_needle, green_haystack)
}
