% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfData-plotMethods.R
\name{plot,cfScreenObs,missing-method}
\alias{plot,cfScreenObs,missing-method}
\alias{plot.cfScreenObs}
\title{Plot Screen Observations}
\usage{
\S4method{plot}{cfScreenObs,missing}(
  x,
  y,
  ggtheme = c("grey", "gray", "bw", "linedraw", "light", "minimal", "classic"),
  scales = c("fixed", "free_x", "free_y", "free"),
  n_col = 1,
  ...
)
}
\arguments{
\item{x}{a cfScreenObs object.}

\item{y}{missing.}

\item{ggtheme}{character string (partially) matching the
\code{\link[ggplot2]{ggtheme}} to be used for plotting, see
'Theme Selection' below.}

\item{scales}{character string partially matching the \code{scales} argument
in the \code{link[ggplot2]{facet_wrap}} function.}

\item{n_col}{the number of columns of plots (default 1).}

\item{...}{further arguments passed to \code{\link[ggplot2]{theme}}.}
}
\description{
Plot temperature data from screen observations (degrees celsius) through time.
}
\details{
Temperature data from screen observations include the air, and wet bulb,
temperature at the time the measurement was taken (dry bulb and wet bulb
respectively), and the dew point. The dew point is the air temperature at
which dew starts to form. That is the temperature to which a given air parcel
must be cooled at constant pressure and constant water vapour content in
order for saturation to occur.

The resulting figure plots the dry bulb, wet bulb and dew point temperatures
on the same  scale, for each station.
}
\examples{
\dontrun{
# Retrieve public temperature data from screen observations for the last week
# at Reefton Ews station

# Subtract 7 days from today's date to get the start date
last_week = paste(as.character(Sys.Date() - 7), 0)

reefton_screenobs = cf_query(cf_user(), cf_datatype(4, 1, 1), cf_station(),
                             start_date = last_week)

class(reefton_screenobs) # cfScreenObs object

# Plot the temperature data using the defaults
plot(reefton_screenobs)

# Enlarge the text and add the observations as points
library(ggplot2) # for element_text() and geom_point()
plot(reefton_screenobs, ggtheme = "bw", text = element_text(size = 16)) +
  geom_point(size = 3, shape = 1)

# Save the plot as a png to the current working directory
library(ggplot2) # for ggsave()
ggsave("my_screenobs_plot.png")
}
}
\references{
\href{https://cliflo.niwa.co.nz/pls/niwp/wh.do_help?id=ls_scr1}{Screen Observation details}.
}
\seealso{
\code{\link{plot,cfDataList,missing-method}} for general
  information on default plotting of \code{cfData} and \code{cfDataList}
  objects, and the links within. See \code{\link{cf_query}} for creating
  \code{cfScreenObs} objects.

  Refer to \code{\link[ggplot2]{theme}} for more possible arguments to pass
  to these methods.
}
