% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/climaemet_main.R
\name{ggstripes_station}
\alias{ggstripes_station}
\title{Station climate stripes graph}
\usage{
ggstripes_station(
  station,
  apikey,
  start = 1950,
  end = 2020,
  with_labels = c("yes, no")
)
}
\arguments{
\item{station}{Station identifier code (see \code{\link{aemet_stations}}).}

\item{apikey}{Personal API key (see \url{https://opendata.aemet.es/centrodedescargas/obtencionAPIKey}).}

\item{start}{a start year (format: \%Y)}

\item{end}{a end year (format: \%Y)}

\item{with_labels}{Indicates whether to use labels for the graph or not}
}
\value{
a ggplot image
}
\description{
Plot climate stripes graph for a station
}
\examples{
\dontrun{
ggstripes_station(station, apikey, with_labels = "yes")
}
}
