% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aemet_forecast_beach.R
\name{aemet_forecast_beaches}
\alias{aemet_forecast_beaches}
\title{Forecast database for beaches}
\usage{
aemet_forecast_beaches(
  x,
  verbose = FALSE,
  return_sf = FALSE,
  extract_metadata = FALSE,
  progress = TRUE
)
}
\arguments{
\item{x}{A vector of beaches codes to extract. See \code{\link[=aemet_beaches]{aemet_beaches()}}.}

\item{verbose}{Logical \code{TRUE/FALSE}. Provides information about the flow of
information between the client and server.}

\item{return_sf}{Logical \code{TRUE} or \code{FALSE}.
Should the function return an \code{\link[sf:sf]{sf}} spatial object? If \code{FALSE}
(the default value) it returns a \code{\link[tibble:tibble]{tibble}}. Note that
you need to have the \CRANpkg{sf} package installed.}

\item{extract_metadata}{Logical \code{TRUE/FALSE}. On \code{TRUE} the output is
a \code{\link[tibble:tibble]{tibble}} with the description of the fields. See also
\code{\link[=get_metadata_aemet]{get_metadata_aemet()}}.}

\item{progress}{Logical, display a \code{\link[cli:cli_progress_bar]{cli::cli_progress_bar()}} object. If
\code{verbose = TRUE} won't be displayed.}
}
\value{
A \code{\link[tibble:tibble]{tibble}} or a \CRANpkg{sf} object.
}
\description{
Get a database of daily weather forecasts for a beach. Beach database can
be accessed with \code{\link[=aemet_beaches]{aemet_beaches()}}.
}
\section{API Key}{
You need to set your API Key globally using \code{\link[=aemet_api_key]{aemet_api_key()}}.
}

\examples{
\dontshow{if (aemet_detect_api_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Forecast for beaches in Palma, Mallorca
library(dplyr)
library(ggplot2)

palma_b <- aemet_beaches() \%>\%
  filter(ID_MUNICIPIO == "07040")

forecast_b <- aemet_forecast_beaches(palma_b$ID_PLAYA)
glimpse(forecast_b)

ggplot(forecast_b) +
  geom_line(aes(fecha, tagua_valor1, color = nombre)) +
  facet_wrap(~nombre, ncol = 1) +
  labs(
    title = "Water temperature in beaches of Palma (ES)",
    subtitle = "Forecast 3-days",
    x = "Date",
    y = "Temperature (Celsius)",
    color = "Beach"
  )
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=aemet_beaches]{aemet_beaches()}} for beaches codes.

Other aemet_api_data: 
\code{\link{aemet_alert_zones}()},
\code{\link{aemet_alerts}()},
\code{\link{aemet_beaches}()},
\code{\link{aemet_daily_clim}()},
\code{\link{aemet_extremes_clim}()},
\code{\link{aemet_forecast_daily}()},
\code{\link{aemet_forecast_fires}()},
\code{\link{aemet_last_obs}()},
\code{\link{aemet_monthly}},
\code{\link{aemet_normal}},
\code{\link{aemet_stations}()}

Other forecasts: 
\code{\link{aemet_forecast_daily}()},
\code{\link{aemet_forecast_fires}()},
\code{\link{aemet_forecast_tidy}()}
}
\concept{aemet_api_data}
\concept{forecasts}
