\name{depstat}
\alias{depstat}
\title{Compute averages for a specified period}
\description{
  Listing of monthly and annual average values for a specified period,
  from data generated by \code{\link{depudm}}.
}
\usage{
  depstat(varcli, anyi, anyf, anyip = anyi, anyfp = anyf, nm = 12,
    ndec = 1, vala = 2)
}
\arguments{
  \item{varcli}{Acronym of the name of the studied climatic variable,
    as in the data file name.}
  \item{anyi}{Initial year of the data present in the file (four digits)}
  \item{anyf}{Final year of the data present in the file (four digits)}
  \item{anyip}{First year of the desired period (>=\code{anyi}, with 4 digits)}
  \item{anyfp}{Last year of the desired period (<=\code{anyf}, with 4 digits)}
  \item{nm}{Number of series in each station. (Default=12, for monthly data).}
  \item{ndec}{Number of decimal places to be saved in file
    \file{VAR\_AI-AF.dep}}
  \item{vala}{Kind of annual value:
    \describe{
      \item{1:}{Sum of monthly values,}
      \item{2:}{Average of monthly values,}
      \item{3:}{Maximum monthly value,}
      \item{4:}{Minimum monthly value.}
    }
  }
}
\details{
  Purged data are read from file \file{VAR\_AI-AF.dep}, generated by
  \code{\link{depudm}}, while the average data for the specified period
  (ai-af) are saved in \file{VAR\_ai-af.med}
}
\value{
  This function does not return any value.
}
\seealso{\code{\link{depudm}}}
\examples{
  #Function depudm must be run first (see the example), to create
  #  the file 'PTOT_51-00.dep'. Then you can run:
  \dontrun{depstat("PTOT",1951,2000,1971,2000,vala=1)}
  #See the results in the file 'PTOT_71-00.med' created by depstat.
}
\keyword{datagen}
