% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/return_calcs.R
\name{calc_returnValue_fevd}
\alias{calc_returnValue_fevd}
\title{Calculates return value and standard error given return period(s) of interest}
\usage{
calc_returnValue_fevd(fit, returnPeriod, covariates = NULL)
}
\arguments{
\item{fit}{fitted object from \pkg{extRemes} \code{fevd}}

\item{returnPeriod}{value(s) for which return value is desired}

\item{covariates}{matrix of covariate values, each row a set of covariates for which the return value is desired}
}
\description{
Calculates return value (also known as the return level) given return period(s) of interest, using model fit from \code{extRemes::fevd}. Standard error is obtained via the delta method. The return value is the value for which the expected number of blocks until an event that exceeds that value is equal to the return period. For non-stationary models (those that include covariates for the location, scale, and/or shape parameters, return values and standard errors are returned for as many sets of covariates as provided.
}

