% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots-utility-watermark.R
\name{addWatermark}
\alias{addWatermark}
\title{Add a watermark to a \code{plotly} object.}
\usage{
addWatermark(pl, watermark = NULL)
}
\arguments{
\item{pl}{\code{plotly} object.}

\item{watermark}{(optional) String with path to a file containing a watermark.}
}
\value{
\code{plotly} object with a watermark (if specified)
}
\description{
Add a watermark to a \code{plotly} object.
}
\examples{
watermark <- tempfile(pattern = "watermark", fileext = ".png")
getWatermark(file = watermark)
addWatermark(pl = plotly::plot_ly(), watermark = watermark)
}
\seealso{
Other watermark helpers: 
\code{\link{getWatermark}()}
}
\concept{watermark helpers}
