% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk_2cmt_inf_dose_from_cmax.R
\name{pk_2cmt_inf_dose_from_cmax}
\alias{pk_2cmt_inf_dose_from_cmax}
\title{Calculate dose to achieve steady state Cmax
for 2-compartmental PK model with infusion dosing at steady state}
\usage{
pk_2cmt_inf_dose_from_cmax(
  cmax = 1,
  tau = 12,
  t_inf = 1,
  CL = 3,
  V = 30,
  Q = 2,
  V2 = 20
)
}
\arguments{
\item{cmax}{desired trough concentration}

\item{tau}{dosing interval}

\item{t_inf}{infusion time}

\item{CL}{clearance}

\item{V}{volume of distribution}

\item{Q}{inter-compartimental clearance}

\item{V2}{volume of peripheral compartment}
}
\description{
Calculate dose to achieve steady state Cmax
for 2-compartmental PK model with infusion dosing at steady state
}
\examples{
dos <- pk_2cmt_inf_dose_from_cmax(
  cmax = 25, tau = 12, t_inf = 2,
  CL = 5, V = 50, Q = 20, V2 = 200)
find_nearest_dose(dos, 100)
}
