% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk_1cmt_inf_dose_from_cmin.R
\name{pk_1cmt_inf_dose_from_cmin}
\alias{pk_1cmt_inf_dose_from_cmin}
\title{Calculate dose to achieve steady state trough
for 1-compartmental PK model with infusion dosing at steady state}
\usage{
pk_1cmt_inf_dose_from_cmin(cmin = 1, tau = 12, t_inf = 1, CL = 3,
  V = 30)
}
\arguments{
\item{cmin}{desired trough concentration}

\item{tau}{dosing interval}

\item{t_inf}{infusion time}

\item{CL}{clearance}

\item{V}{volume of distribution}
}
\description{
Calculate dose to achieve steady state trough
for 1-compartmental PK model with infusion dosing at steady state
}
\examples{
dos <- pk_1cmt_inf_dose_from_cmin(
  cmin = 20, tau = 12, t_inf = 2,
  CL = 5, V = 50)
find_nearest_dose(dos, 100)
}
