% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regressions.r
\name{regression_forest}
\alias{regression_forest}
\title{Forest plot of regression results}
\usage{
regression_forest(
  data,
  model_vars,
  y,
  time = NULL,
  as_univariate = FALSE,
  est_nsmall = 2,
  p_nsmall = 3,
  show_vars = NULL,
  save_plot = FALSE,
  filename = NULL,
  ...
)
}
\arguments{
\item{data}{A data frame.}

\item{model_vars}{A character vector or a named list of predictor variables for different models.}

\item{y}{A character string of the outcome variable.}

\item{time}{A character string of the time variable. If \code{NULL}, logistic regression is used.
Otherwise, Cox proportional hazards regression is used.}

\item{as_univariate}{A logical value indicating whether to treat the model_vars as univariate.}

\item{est_nsmall}{An integer specifying the precision for the estimates in the plot.}

\item{p_nsmall}{An integer specifying the number of decimal places for the p-values.}

\item{show_vars}{A character vector of variable names to be shown in the plot. If \code{NULL}, all variables are shown.}

\item{save_plot}{A logical value indicating whether to save the plot.}

\item{filename}{A character string specifying the filename for the plot. If \code{NULL}, a default filename is used.}

\item{...}{Additional arguments passed to the \code{forestploter::forest} function.}
}
\value{
A \code{gtable} object.
}
\description{
Generate the forest plot of logistic or Cox regression with different models.
}
\examples{
data(cancer, package = "survival")
cancer$ph.ecog_cat <- factor(cancer$ph.ecog, levels = c(0:3), labels = c("0", "1", ">=2", ">=2"))
regression_forest(cancer,
  model_vars = c("age", "sex", "wt.loss", "ph.ecog_cat", "meal.cal"), y = "status", time = "time",
  as_univariate = TRUE, save_plot = FALSE
)

regression_forest(cancer,
  model_vars = c("age", "sex", "wt.loss", "ph.ecog_cat", "meal.cal"), y = "status", time = "time",
  show_vars = c("age", "sex", "ph.ecog_cat", "meal.cal"), save_plot = FALSE
)

regression_forest(cancer,
  model_vars = list(
    M0 = c("age"),
    M1 = c("age", "sex", "wt.loss", "ph.ecog_cat", "meal.cal"),
    M2 = c("age", "sex", "wt.loss", "ph.ecog_cat", "meal.cal", "pat.karno")
  ),
  y = "status", time = "time",
  show_vars = c("age", "sex", "ph.ecog_cat", "meal.cal"), save_plot = FALSE
)
}
