% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clmplusRtTriangle.R
\name{clmplus.default}
\alias{clmplus.default}
\title{Fit chain-ladder+ to reverse time triangles.}
\usage{
\method{clmplus}{default}(RtTriangle, hazard.model = NULL, ...)
}
\arguments{
\item{RtTriangle}{RtTriangle object to be fitted.}

\item{hazard.model}{hazard model supported from our package, must be provided as a string. The model can be choosen from:
\itemize{
\item{'a': Age model, this is equivalent to the Mack chain-ladder.}
\item{'ac': Age and cohort effects.}
\item{'ap': Age and cohort effects.}
\item{'apc': Age cohort and period effects.}
\item{'cbd': Cairns-Blake-Dowd mortality model (CBD).}
\item{'m6': CBD with cohorts.}
\item{'m7': CBD m7 extension.}
\item{'m8': CBD m7 extension.}
}}

\item{...}{parameters to be passed to clmplus.}
}
\value{
No return value, called as clmplus method default.
}
\description{
This function allows to fit chain-ladder+ models to cumulative payments run-off triangles.
}
\references{
Hiabu, Munir. “On the relationship between classical chain ladder and granular reserving.” 
Scandinavian Actuarial Journal 2017 (2017): 708 - 729.
}
