% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotclmpluspredictions.R
\name{plot.clmpluspredictions}
\alias{plot.clmpluspredictions}
\title{Plot the hazard model fitted and forecasted parameters}
\usage{
\method{plot}{clmpluspredictions}(x, cy.type = "fe", ...)
}
\arguments{
\item{x}{\code{clmpluspredictions}, Model effects (fitted and extrapolated) to be plotted.}

\item{cy.type}{\code{character}, whether to show fitted period effect with or without extrapolatio Default is "fe", standing for fitted and extrapolated. Alternative is to specify "f" for fitted effect.}

\item{...}{Arguments to be passed to plot.}
}
\value{
No return value, plots coefficients of the hazard models.
}
\description{
This function allows to define the behavior of the triangle payments.
}
\examples{
data(sifa.mtpl)
sifa.mtpl.rtt <- AggregateDataPP(cumulative.payments.triangle=sifa.mtpl)
clm.fit<-clmplus(sifa.mtpl.rtt, 'a')
clm <- predict(clm.fit)
plot(clm)

}
\references{
Pittarello, G., Hiabu, M., & Villegas, A. M. (2023). Replicating and extending chain-ladder via an age-period-cohort structure on the claim development in a run-off triangle. arXiv preprint arXiv:2301.03858.
}
