% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quarterly-year-quarter-day.R
\name{year-quarter-day-narrow}
\alias{year-quarter-day-narrow}
\alias{calendar_narrow.clock_year_quarter_day}
\title{Narrow: year-quarter-day}
\usage{
\method{calendar_narrow}{clock_year_quarter_day}(x, precision)
}
\arguments{
\item{x}{\verb{[clock_year_quarter_day]}

A year-quarter-day vector.}

\item{precision}{\verb{[character(1)]}

One of:
\itemize{
\item \code{"year"}
\item \code{"quarter"}
\item \code{"day"}
\item \code{"hour"}
\item \code{"minute"}
\item \code{"second"}
\item \code{"millisecond"}
\item \code{"microsecond"}
\item \code{"nanosecond"}
}}
}
\value{
\code{x} narrowed to the supplied \code{precision}.
}
\description{
This is a year-quarter-day method for the \code{\link[=calendar_narrow]{calendar_narrow()}} generic. It
narrows a year-quarter-day vector to the specified \code{precision}.
}
\examples{
# Day precision
x <- year_quarter_day(2019, 1, 5)
x

# Narrow to quarter precision
calendar_narrow(x, "quarter")
}
