/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.cbp.ppe.gui;

import com.norbl.cbp.ppe.NetworkInfo;
import com.norbl.cbp.ppe.NetworkTableModel;
import com.norbl.cbp.ppe.NiM;
import com.norbl.cbp.ppe.PPEManager;
import com.norbl.cbp.ppe.gui.ActionCommandNetworkManager;
import com.norbl.util.ExceptionHandler;
import java.awt.EventQueue;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;

public class NetworkTablePopup {
    PPEManager ppeManager;
    ActionListener actionListener;
    JTable table;
    NetworkTableModel model;
    int networkNameCol;
    ClickHandler clickHandler;
    NetworkInfo ni;
    List<MiSpec> miSpecs;

    public NetworkTablePopup(PPEManager ppeManager, ActionListener actionListener, JTable table) {
        this.table = table;
        this.ppeManager = ppeManager;
        this.actionListener = actionListener;
        this.model = (NetworkTableModel)table.getModel();
        this.networkNameCol = this.model.getNetworkNameColumnIndex();
        this.clickHandler = new ClickHandler();
        table.addMouseListener(this.clickHandler);
    }

    void createPopup(MouseEvent e) {
        JPopupMenu menu = new JPopupMenu(this.ni.getNetworkName());
        for (MiSpec mis : this.miSpecs) {
            menu.add(mis.createMenuItem());
        }
        menu.show(e.getComponent(), e.getX(), e.getY());
    }

    private class MiSpec {
        boolean enable;
        ActionCommandNetworkManager ac;
        String txt;

        MiSpec(PPEManager.Op op) {
            this.ac = new ActionCommandNetworkManager(op.toString(), NetworkTablePopup.this.ni.getNetworkID());
            this.txt = op.textMi;
            this.enable = NetworkTablePopup.this.ni.isRunning();
        }

        JMenuItem createMenuItem() {
            JMenuItem mi = new JMenuItem();
            mi.setActionCommand(this.ac.toActionEventString());
            mi.setText(this.txt);
            mi.addActionListener(NetworkTablePopup.this.actionListener);
            mi.setEnabled(this.enable);
            return mi;
        }
    }

    class CreatePopup
    extends Thread {
        MouseEvent e;
        int idx;
        boolean rebootInstances;
        boolean terminateInstances;
        boolean startRmxServerOnMaster;
        boolean configureOmpi;
        boolean startRserveController;

        CreatePopup(MouseEvent e) {
            this.e = e;
        }

        @Override
        public void run() {
            try {
                int idx = NetworkTablePopup.this.table.rowAtPoint(this.e.getPoint());
                if (idx < 0) {
                    return;
                }
                Object x = NetworkTablePopup.this.model.getValueAt(idx, NetworkTablePopup.this.networkNameCol);
                if (x == null) {
                    return;
                }
                String networkName = (String)x;
                NetworkTablePopup.this.ni = NiM.getForName(networkName);
                if (NetworkTablePopup.this.ni == null) {
                    return;
                }
                NetworkTablePopup.this.miSpecs = new ArrayList<MiSpec>();
                NetworkTablePopup.this.miSpecs.add(new MiSpec(PPEManager.Op.rebootInstances));
                NetworkTablePopup.this.miSpecs.add(new MiSpec(PPEManager.Op.terminateInstances));
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NetworkTablePopup.this.createPopup(CreatePopup.this.e);
                    }
                });
            }
            catch (Exception xxx) {
                ExceptionHandler.gui(xxx);
            }
        }
    }

    class ClickHandler
    extends MouseAdapter {
        ClickHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            new CreatePopup(e).start();
        }
    }
}

