/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.cbp.ppe.usermonitor;

import com.norbl.cbp.ppe.PPEManager;
import com.norbl.cbp.ppe.usermonitor.AuthorizationFrame;
import com.norbl.cbp.ppe.usermonitor.Message;
import com.norbl.cbp.ppe.usermonitor.MonitorHostname;
import com.norbl.cbp.ppe.usermonitor.ReadWriteConnection;
import com.norbl.util.gui.GuiUtil;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.Socket;
import java.net.URI;

public class AuthorizationClient
implements ActionListener {
    PPEManager ppeManager;
    AuthorizationFrame f;

    public AuthorizationClient(PPEManager ppeManger) {
        this.ppeManager = ppeManger;
    }

    public void runAuthorizationDialog() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AuthorizationClient.this.f = new AuthorizationFrame(AuthorizationClient.this);
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        String c = ev.getActionCommand();
        if (c.equals("cancel")) {
            if (this.f != null) {
                this.f.dispose();
            }
        } else if (c.equals("continue")) {
            String ema = this.f.getEmailAddress();
            if (this.isValueEmailAddress(ema)) {
                this.doAuthorization(ema);
                this.f.dispose();
            } else if (!GuiUtil.answerIsYes(new String[]{"'" + ema + "' is not a valid email address.", " ", "Try again?"}, "Invalid email address") && this.f != null) {
                this.f.dispose();
            }
        }
    }

    private void doAuthorization(String ema) {
        try {
            String hostname = MonitorHostname.getHostNameFromS3();
            if (hostname == null) {
                throw new Exception("Unable to get the hostname of the ppe user monitor server; this implies an error accessing S3 so check you connection to the internet.");
            }
            Socket socket = null;
            try {
                socket = new Socket(hostname, 16020);
            }
            catch (Exception xxx) {
                GuiUtil.warning(new String[]{"Exception: " + xxx.getMessage(), "This exception occurred while attempting to connect to our", "server on port " + Integer.toString(16020) + "(our server is running on an ec2 instance).", "If you are accessing the internet via a proxy server,", "perhaps it's blocking access."}, "Exception");
            }
            ReadWriteConnection con = new ReadWriteConnection(socket, ReadWriteConnection.HostType.client);
            con.writeMessage(new Message.AddUser(ema));
            Message r = (Message)con.readMessage();
            if (r instanceof Message.NewUserUrl) {
                this.ppeManager.updateParamsReBillingAuthorizationID(ema);
                this.ppeManager.updateDisplayedBillingID();
                Message.NewUserUrl um = (Message.NewUserUrl)r;
                Desktop.getDesktop().browse(new URI(um.url));
            } else if (r instanceof Message.Error) {
                GuiUtil.exceptionMessage(((Message.Error)r).exception);
            } else {
                GuiUtil.info(new String[]{"An error of unknown type occurred.", " ", "You may want to try the authorization again."}, "Error");
            }
        }
        catch (Exception xxx) {
            GuiUtil.exceptionMessageOnly(xxx);
        }
    }

    private boolean isValueEmailAddress(String ema) {
        if (ema == null) {
            return false;
        }
        if (ema.length() < 4) {
            return false;
        }
        return ema.contains("@");
    }

    public void windowClosed() {
        if (this.f != null) {
            this.f.dispose();
        }
    }
}

