/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.cbp.ppe.usermonitor;

import com.norbl.cbp.ppe.usermonitor.Message;
import com.norbl.cbp.ppe.usermonitor.MonitorHostname;
import com.norbl.cbp.ppe.usermonitor.ReadWriteConnection;
import com.norbl.cbp.ppe.usermonitor.S3Key;
import com.norbl.util.ArgvUtil;
import com.norbl.util.aws.EC2Utils;
import java.io.File;
import java.net.Socket;

public class PPEClientMonitorApp {
    static final long REPORT_INCREMENT = 3600100L;
    static final long NAP_TIME = 60000L;
    private String uid;
    private String peid;
    private boolean verbose;
    private long reportIncrement;

    public PPEClientMonitorApp(String[] argv) {
        String v = ArgvUtil.getVal(argv, "verbose");
        this.verbose = v != null;
        int ri = ArgvUtil.getIntVal(argv, "ri", -1);
        this.reportIncrement = ri <= 0 ? 3600100L : 1000L * (long)ri;
        this.showV("reportIncrement=" + this.reportIncrement);
    }

    public void go() {
        if (!this.checkAuthorization()) {
            this.showV("Authorization failed, disabling");
            PPEClientMonitorApp.disable();
            return;
        }
        if (this.uid == null) {
            System.err.println("PPEClientMonitorApp.run() null peod -> possible BUG.");
            System.exit(0);
        }
        this.reportUsage();
    }

    boolean checkAuthorization() {
        try {
            this.uid = EC2Utils.getInstanceUserdata();
            if (this.uid == null) {
                return false;
            }
            this.showV("userData=" + this.uid);
            if (this.uid.equals("nil")) {
                return false;
            }
            this.peid = S3Key.createPeidKey(this.uid);
            this.showV("peid=" + this.peid);
            return true;
        }
        catch (Exception iox) {
            return true;
        }
    }

    private static void disable() {
        System.out.println("Disabling ...");
        PPEClientMonitorApp.renameIfExtant(new File("/home/ec2-user"));
        PPEClientMonitorApp.renameIfExtant(new File("/home/apps"));
    }

    private static void renameIfExtant(File dir) {
        if (!dir.exists()) {
            return;
        }
        if (!dir.isDirectory()) {
            return;
        }
        File f = new File(dir, "openmpi");
        if (f.exists()) {
            f.renameTo(new File(dir, "xxxopenmpi"));
        }
    }

    void reportUsage() {
        try {
            String monitorHost = MonitorHostname.getHostNameFromS3();
            ReadWriteConnection con = null;
            Socket socket = null;
            Message.BillableUsage m = new Message.BillableUsage(this.uid);
            long lastReportTime = 0L;
            block10: while (true) {
                try {
                    while (true) {
                        long curTime;
                        if ((curTime = System.currentTimeMillis()) >= lastReportTime + this.reportIncrement) {
                            try {
                                socket = new Socket(monitorHost, 16020);
                                if (this.verbose) {
                                    System.out.println("Writing bill message.");
                                }
                                con = new ReadWriteConnection(socket, ReadWriteConnection.HostType.client);
                                con.writeMessage(m);
                                if (this.verbose) {
                                    System.out.println("... wrote bill message.");
                                }
                                Message r = (Message)con.readMessage();
                                if (this.verbose) {
                                    System.out.println("... got reply=" + r);
                                }
                                con.close();
                                socket.close();
                                if (this.verbose) {
                                    System.out.println("___ done");
                                }
                            }
                            catch (Exception xxx) {
                                try {
                                    if (con != null) {
                                        con.close();
                                    }
                                    if (socket != null) {
                                        socket.close();
                                    }
                                }
                                catch (Exception zzz) {
                                    System.err.println(zzz);
                                }
                                System.err.println(xxx.getMessage());
                            }
                            lastReportTime = curTime;
                            continue;
                        }
                        try {
                            Thread.sleep(60000L);
                            continue block10;
                        }
                        catch (InterruptedException ix) {
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception xxx) {
                    System.err.println(xxx);
                    continue;
                }
                break;
            }
        }
        catch (Exception xxx) {
            System.err.println(xxx);
            System.exit(0);
            return;
        }
    }

    void showV(String m) {
        if (this.verbose) {
            System.out.println(m);
        }
    }

    public static void main(String[] argv) {
        PPEClientMonitorApp app = new PPEClientMonitorApp(argv);
        app.go();
    }
}

